/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient
extends OncRpcUdpClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;

    public OncRpcPortmapClient(InetAddress host) throws IOException, OncRpcException {
        super(host, 100000, 2, 111);
    }

    public int getPort(int program, int version, int protocol) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, protocol, 0);
        OncRpcGetPortResult result = new OncRpcGetPortResult();
        try {
            this.call(3, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        if (result.port == 0) {
            throw new OncRpcProgramNotRegisteredException();
        }
        return result.port;
    }

    public boolean setPort(int program, int version, int protocol, int port) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, protocol, port);
        XdrBoolean result = new XdrBoolean(false);
        try {
            this.call(1, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        return result.booleanValue();
    }

    public boolean unsetPort(int program, int version) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, 0, 0);
        XdrBoolean result = new XdrBoolean(false);
        try {
            this.call(2, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        return result.booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult result = new OncRpcDumpResult();
        try {
            this.call(4, XdrVoid.XDR_VOID, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        Object[] info = new OncRpcServerIdent[result.servers.size()];
        result.servers.copyInto(info);
        return info;
    }
}

