/*
 * Decompiled with CFR 0.152.
 */
package joeshmoe.mpeg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import joeshmoe.mpeg.ID3Tag;

public class ID3Tagger {
    public static ID3Tag readTag(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        if (randomAccessFile.length() < 128L) {
            randomAccessFile.close();
            return null;
        }
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        ID3Tag iD3Tag = new ID3Tag();
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[30];
        byte[] byArray3 = new byte[30];
        byte[] byArray4 = new byte[30];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[30];
        byte[] byArray7 = new byte[1];
        randomAccessFile.readFully(byArray);
        if (!new String(byArray).equals("TAG")) {
            randomAccessFile.close();
            return null;
        }
        randomAccessFile.readFully(byArray2);
        iD3Tag.setSong(new String(byArray2).trim());
        randomAccessFile.readFully(byArray3);
        iD3Tag.setArtist(new String(byArray3).trim());
        randomAccessFile.readFully(byArray4);
        iD3Tag.setAlbum(new String(byArray4).trim());
        randomAccessFile.readFully(byArray5);
        iD3Tag.setYear(new String(byArray5).trim());
        randomAccessFile.readFully(byArray6);
        iD3Tag.setComment(new String(byArray6).trim());
        randomAccessFile.readFully(byArray7);
        iD3Tag.setGenreID(byArray7[0]);
        randomAccessFile.close();
        return iD3Tag;
    }

    public static boolean writeTag(File file, ID3Tag iD3Tag) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        if (ID3Tagger.readTag(file) == null) {
            randomAccessFile.seek(randomAccessFile.length());
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
        }
        randomAccessFile.writeBytes("TAG");
        StringBuffer stringBuffer = iD3Tag.getSong() != null ? new StringBuffer(iD3Tag.getSong()) : new StringBuffer();
        stringBuffer.setLength(30);
        randomAccessFile.writeBytes(stringBuffer.toString());
        StringBuffer stringBuffer2 = iD3Tag.getArtist() != null ? new StringBuffer(iD3Tag.getArtist()) : new StringBuffer();
        stringBuffer2.setLength(30);
        randomAccessFile.writeBytes(stringBuffer2.toString());
        StringBuffer stringBuffer3 = iD3Tag.getAlbum() != null ? new StringBuffer(iD3Tag.getAlbum()) : new StringBuffer();
        stringBuffer3.setLength(30);
        randomAccessFile.writeBytes(stringBuffer3.toString());
        StringBuffer stringBuffer4 = iD3Tag.getYear() != null ? new StringBuffer(iD3Tag.getYear()) : new StringBuffer();
        stringBuffer4.setLength(4);
        randomAccessFile.writeBytes(stringBuffer4.toString());
        StringBuffer stringBuffer5 = iD3Tag.getComment() != null ? new StringBuffer(iD3Tag.getComment()) : new StringBuffer();
        stringBuffer5.setLength(30);
        randomAccessFile.writeBytes(stringBuffer5.toString());
        randomAccessFile.writeByte(iD3Tag.getGenreID());
        randomAccessFile.close();
        return true;
    }
}

