/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;

public abstract class OncRpcClient {
    protected InetAddress host;
    protected int timeout = 30000;
    protected int program;
    protected int version;
    protected int port;
    protected int xid;
    protected OncRpcClientAuth auth;

    protected OncRpcClient(InetAddress host, int program, int version, int port, int protocol) throws IOException, OncRpcException {
        this.host = host;
        this.program = program;
        this.version = version;
        long seed = System.currentTimeMillis();
        this.xid = (int)seed ^ (int)(seed >>> 32);
        if (port == 0 && protocol != -42) {
            OncRpcPortmapClient portmap = new OncRpcPortmapClient(host);
            try {
                port = portmap.getPort(program, version, protocol);
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                portmap.close();
                throw throwable;
            }
            portmap.close();
            {
            }
        }
        this.port = port;
    }

    public static OncRpcClient newOncRpcClient(InetAddress host, int program, int version, int protocol) throws IOException, OncRpcException {
        return OncRpcClient.newOncRpcClient(host, program, version, 0, protocol);
    }

    public static OncRpcClient newOncRpcClient(InetAddress host, int program, int version, int port, int protocol) throws IOException, OncRpcException {
        switch (protocol) {
            case 17: {
                return new OncRpcUdpClient(host, program, version, port);
            }
            case 6: {
                return new OncRpcTcpClient(host, program, version, port);
            }
        }
        throw new OncRpcException(17);
    }

    public void close() throws OncRpcException {
    }

    public abstract void call(int var1, XdrAble var2, XdrAble var3) throws OncRpcException;

    public void setTimeout(int milliseconds) {
        if (milliseconds < 0) {
            throw new IllegalArgumentException("timeouts can not be negative.");
        }
        this.timeout = milliseconds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAuth(OncRpcClientAuth auth) {
        this.auth = auth;
    }

    public OncRpcClientAuth getAuth() {
        return this.auth;
    }

    protected void nextXid() {
        ++this.xid;
    }
}

