/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress host, int program, int version) throws IOException, OncRpcException {
        this(host, program, version, 0, 8192);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port) throws IOException, OncRpcException {
        this(host, program, version, port, 8192);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize) throws IOException, OncRpcException {
        super(host, program, version, port, 6);
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socket = new Socket(host, this.port);
        this.socketHelper = new OncRpcTcpSocketHelper(this.socket);
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.socket.setSoTimeout(this.timeout);
        this.sendingXdr = new XdrTcpEncodingStream(this.socket, 8192);
        this.receivingXdr = new XdrTcpDecodingStream(this.socket, 8192);
    }

    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    public synchronized void call(int procedureNumber, XdrAble params, XdrAble result) throws OncRpcException {
        for (int refreshesLeft = 1; refreshesLeft >= 0; --refreshesLeft) {
            this.nextXid();
            OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
            OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
            try {
                this.socket.setSoTimeout(this.transmissionTimeout);
                this.sendingXdr.beginEncoding(null, 0);
                callHeader.xdrEncode(this.sendingXdr);
                params.xdrEncode(this.sendingXdr);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException e) {
                throw new OncRpcException(3, e.getLocalizedMessage());
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                while (true) {
                    this.socket.setSoTimeout(this.timeout);
                    this.receivingXdr.beginDecoding();
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    replyHeader.xdrDecode(this.receivingXdr);
                    if (replyHeader.messageId == callHeader.messageId) break;
                    this.receivingXdr.endDecoding();
                }
                if (!replyHeader.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (refreshesLeft > 0 && replyHeader.replyStatus == 1 && replyHeader.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw replyHeader.newException();
                }
                result.xdrDecode(this.receivingXdr);
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException e) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException e) {
                throw new OncRpcException(4, e.getLocalizedMessage());
            }
        }
    }

    public synchronized void batchCall(int procedureNumber, XdrAble params, boolean flush) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.sendingXdr.beginEncoding(null, 0);
            callHeader.xdrEncode(this.sendingXdr);
            params.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(flush);
        }
        catch (IOException e) {
            throw new OncRpcException(3, e.getLocalizedMessage());
        }
    }

    public void setTimeout(int milliseconds) {
        super.setTimeout(milliseconds);
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }
}

