/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;

public class OncRpcTcpSocketHelper {
    private Socket socket;
    private Method methodSetSendBufferSize;
    private Method methodSetReceiveBufferSize;
    private Method methodGetSendBufferSize;
    private Method methodGetReceiveBufferSize;

    public OncRpcTcpSocketHelper(Socket socket) {
        this.socket = socket;
        this.queryMethods();
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetSendBufferSize.invoke((Object)this.socket, new Integer(size));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.methodGetSendBufferSize != null) {
            try {
                Object result = this.methodGetSendBufferSize.invoke((Object)this.socket, null);
                if (result instanceof Integer) {
                    int n = (Integer)result;
                    return n;
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                throw new SocketException(t.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
        return 65536;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetReceiveBufferSize.invoke((Object)this.socket, new Integer(size));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.methodGetReceiveBufferSize != null) {
            try {
                Object result = this.methodGetReceiveBufferSize.invoke((Object)this.socket, null);
                if (result instanceof Integer) {
                    int n = (Integer)result;
                    return n;
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                throw new SocketException(t.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
        return 65536;
    }

    protected void queryMethods() {
        Class<?> c = Class.forName("java.net.Socket");
        try {
            this.methodSetSendBufferSize = c.getMethod("setSendBufferSize", Integer.TYPE);
            this.methodGetSendBufferSize = c.getMethod("getSendBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.methodSetReceiveBufferSize = c.getMethod("setReceiveBufferSize", Integer.TYPE);
            this.methodGetReceiveBufferSize = c.getMethod("getReceiveBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

