/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnDecodingInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnum;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParser;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParserException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProgramInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenScanner;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnion;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenVersionInfo;
import org.acplt.oncrpc.apps.jrpcgen.cup_runtime.Symbol;

public class jrpcgen {
    public static final String VERSION = "0.93.0";
    public static final String startDate = new SimpleDateFormat().format(new Date());
    public static Hashtable globalIdentifiers = new Hashtable();
    public static boolean noBackups = false;
    public static Vector programInfos = null;
    public static boolean debug = false;
    public static boolean verbose = false;
    public static boolean parseOnly = false;
    public static File destinationDir = new File(".");
    public static Writer currentFileWriter = null;
    public static PrintWriter currentPrintWriter = null;
    public static String currentFilename = null;
    public static String packageName = null;
    public static String baseClassname = null;
    public static boolean noClient = false;
    public static boolean noServer = false;
    public static String serverClass = null;
    public static String clientClass = null;
    private static String[] baseTypes = new String[]{"void", "boolean", "byte", "short", "int", "long", "float", "double", "String"};

    public static void printHelp() {
        System.out.println("Usage: jrpcgen [-options] x-file");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("  -c <classname>  specify class name of client proxy stub");
        System.out.println("  -d <dir>        specify directory where to place generated source code files");
        System.out.println("  -p <package>    specify package name for generated source code files");
        System.out.println("  -s <classname>  specify class name of server proxy stub");
        System.out.println("  -nobackup       do not make backups of old source code files");
        System.out.println("  -noclient       do not create client proxy stub");
        System.out.println("  -noserver       do not create server proxy stub");
        System.out.println("  -parseonly      parse x-file only but do not create source code files");
        System.out.println("  -verbose        enable verbose output about what jrpcgen is doing");
        System.out.println("  -version        print jrpcgen version and exit");
        System.out.println("  -debug          enables printing of diagnostic messages");
        System.out.println("  -? -help        print this help message and exit");
        System.out.println("  --              end options");
        System.out.println();
    }

    public static PrintWriter createJavaSourceFile(String classname) {
        PrintWriter out;
        String filename = String.valueOf(classname).concat(String.valueOf(".java"));
        File file = new File(destinationDir, filename);
        if (file.exists() && !noBackups) {
            File oldBackup;
            if (!file.isFile()) {
                System.err.println(String.valueOf(String.valueOf("error: source file \"").concat(String.valueOf(filename))).concat(String.valueOf("\"already exists and is not a regular file")));
                System.exit(1);
            }
            if ((oldBackup = new File(destinationDir, String.valueOf(filename).concat(String.valueOf("~")))).isFile()) {
                oldBackup.delete();
            } else if (oldBackup.exists()) {
                System.err.println(String.valueOf(String.valueOf("error: backup source file \"").concat(String.valueOf(filename))).concat(String.valueOf("~\" is not a regular file")));
                System.exit(1);
            }
            if (!file.renameTo(new File(destinationDir, String.valueOf(filename).concat(String.valueOf("~"))))) {
                System.err.println(String.valueOf(String.valueOf("error: can not rename old source code file \"").concat(String.valueOf(filename))).concat(String.valueOf("\"")));
                System.exit(1);
            }
            if (verbose) {
                System.out.println(String.valueOf(String.valueOf("Saved old source code file as \"").concat(String.valueOf(filename))).concat(String.valueOf("~\"")));
            }
        }
        try {
            currentFileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(String.valueOf(String.valueOf("error: can not create \"").concat(String.valueOf(filename))).concat(String.valueOf("\": "))).concat(String.valueOf(e.getLocalizedMessage())));
            System.exit(1);
        }
        if (verbose) {
            System.out.print(String.valueOf(String.valueOf("Creating source code file \"").concat(String.valueOf(filename))).concat(String.valueOf("\"...")));
        }
        currentFilename = filename;
        currentPrintWriter = out = new PrintWriter(currentFileWriter, true);
        out.println("/*");
        out.println(String.valueOf(" * Automatically generated by jrpcgen 0.93.0 on ").concat(String.valueOf(startDate)));
        out.println(" * jrpcgen is part of the \"Remote Tea\" ONC/RPC package for Java");
        out.println(" * See http://acplt.org/ks/remotetea.html for details");
        out.println(" */");
        if (packageName != null && packageName.length() > 0) {
            out.println(String.valueOf(String.valueOf("package ").concat(String.valueOf(packageName))).concat(String.valueOf(";")));
        }
        out.println("import org.acplt.oncrpc.*;");
        out.println("import java.io.IOException;");
        out.println();
        return out;
    }

    public static void closeJavaSourceFile() {
        currentPrintWriter.println(String.valueOf("// End of ").concat(String.valueOf(currentFilename)));
        if (verbose) {
            System.out.println();
        }
        try {
            currentPrintWriter.close();
            currentFileWriter.close();
        }
        catch (IOException e) {
            System.err.println(String.valueOf("Can not close source code file: ").concat(String.valueOf(e.getLocalizedMessage())));
        }
    }

    public static void dumpConstantAndDependency(PrintWriter out, JrpcgenConst c) {
        JrpcgenConst dc;
        if (c.dontTraverseAnyMore) {
            return;
        }
        c.dontTraverseAnyMore = true;
        String dependencyIdentifier = c.getDependencyIdentifier();
        if (dependencyIdentifier != null && (dc = (JrpcgenConst)globalIdentifiers.get(dependencyIdentifier)) != null) {
            jrpcgen.dumpConstantAndDependency(out, dc);
            if (!c.enclosure.equalsIgnoreCase(dc.enclosure)) {
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public static final int ").concat(String.valueOf(c.identifier))).concat(String.valueOf(" = "))).concat(String.valueOf(dc.enclosure))).concat(String.valueOf("."))).concat(String.valueOf(c.value))).concat(String.valueOf(";")));
                return;
            }
        }
        out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public static final int ").concat(String.valueOf(c.identifier))).concat(String.valueOf(" = "))).concat(String.valueOf(c.value))).concat(String.valueOf(";")));
    }

    public static void dumpConstants() {
        PrintWriter out = jrpcgen.createJavaSourceFile(baseClassname);
        out.println("/**");
        out.println(String.valueOf(String.valueOf(" * A collection of constants used by the \"").concat(String.valueOf(baseClassname))).concat(String.valueOf("\" ONC/RPC program.")));
        out.println(" */");
        out.println(String.valueOf(String.valueOf("public interface ").concat(String.valueOf(baseClassname))).concat(String.valueOf(" {")));
        Enumeration globals = globalIdentifiers.elements();
        while (globals.hasMoreElements()) {
            Object o = globals.nextElement();
            if (!(o instanceof JrpcgenConst)) continue;
            JrpcgenConst c = (JrpcgenConst)o;
            if (!baseClassname.equals(c.enclosure)) continue;
            jrpcgen.dumpConstantAndDependency(out, c);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpEnum(JrpcgenEnum e) {
        PrintWriter out = jrpcgen.createJavaSourceFile(e.identifier);
        out.println("/**");
        out.println(" * Enumeration (collection of constants).");
        out.println(" */");
        out.println(String.valueOf(String.valueOf("public interface ").concat(String.valueOf(e.identifier))).concat(String.valueOf(" {")));
        out.println();
        Enumeration enums = e.enums.elements();
        while (enums.hasMoreElements()) {
            JrpcgenConst c = (JrpcgenConst)enums.nextElement();
            jrpcgen.dumpConstantAndDependency(out, c);
        }
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static String xdrBaseType(String type) {
        int size = baseTypes.length;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            return String.valueOf(String.valueOf("Xdr").concat(String.valueOf(type.substring(0, 1).toUpperCase()))).concat(String.valueOf(type.substring(1)));
        }
        return null;
    }

    public static JrpcgenEnDecodingInfo baseEnDecodingSyllable(JrpcgenDeclaration decl) {
        Object o;
        String syllable = decl.type;
        boolean isBase = false;
        int size = baseTypes.length;
        String type = decl.type;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            isBase = true;
            syllable = String.valueOf(syllable.substring(0, 1).toUpperCase()).concat(String.valueOf(syllable.substring(1)));
            break;
        }
        if (!isBase && (o = globalIdentifiers.get(decl.type)) instanceof JrpcgenEnum) {
            isBase = true;
            syllable = "Int";
        }
        if (isBase) {
            String encodingOpts = null;
            String decodingOpts = null;
            if (decl.kind == 1 || decl.kind == 2) {
                if ("opaque".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = "Opaque";
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    } else {
                        syllable = "DynamicOpaque";
                        encodingOpts = null;
                        decodingOpts = null;
                    }
                } else if (!"String".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = String.valueOf(syllable).concat(String.valueOf("Fixed"));
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    }
                    syllable = String.valueOf(syllable).concat(String.valueOf("Vector"));
                }
            }
            JrpcgenEnDecodingInfo result = new JrpcgenEnDecodingInfo(syllable, encodingOpts, decodingOpts);
            return result;
        }
        return null;
    }

    public static String codingMethod(JrpcgenDeclaration decl, boolean encode) {
        if (decl.identifier == null) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        JrpcgenEnDecodingInfo data = jrpcgen.baseEnDecodingSyllable(decl);
        if (data != null) {
            if (encode) {
                code.append("        xdr.xdrEncode");
                code.append(data.syllable);
                code.append("(");
                code.append(decl.identifier);
                if (data.encodingOptions != null) {
                    code.append(", ");
                    code.append(data.encodingOptions);
                }
                code.append(");\n");
            } else {
                code.append("        ");
                code.append(decl.identifier);
                code.append(" = xdr.xdrDecode");
                code.append(data.syllable);
                code.append("(");
                if (data.decodingOptions != null) {
                    code.append(data.decodingOptions);
                }
                code.append(");\n");
            }
            return code.toString();
        }
        if (decl.kind == 0) {
            code.append("        ");
            if (encode) {
                code.append(decl.identifier);
                code.append(".xdrEncode(xdr);\n");
            } else {
                code.append(decl.identifier);
                code.append(" = new ");
                code.append(decl.type);
                code.append("(xdr);\n");
            }
            return code.toString();
        }
        if (decl.kind == 3) {
            code.append("        ");
            if (encode) {
                code.append("if ( ");
                code.append(decl.identifier);
                code.append(" != null ) { ");
                code.append("xdr.xdrEncodeBoolean(true); ");
                code.append(decl.identifier);
                code.append(".xdrEncode(xdr);");
                code.append(" } else { ");
                code.append("xdr.xdrEncodeBoolean(false);");
                code.append(" };\n");
            } else {
                code.append("if ( xdr.xdrDecodeBoolean() ) { ");
                code.append(decl.identifier);
                code.append(" = new ");
                code.append(decl.type);
                code.append("(xdr);");
                code.append(" } else { ");
                code.append(decl.identifier);
                code.append(" = null;");
                code.append(" };\n");
            }
            return code.toString();
        }
        if (encode) {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append(decl.identifier);
                code.append(".length");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            if (decl.kind == 2) {
                code.append("xdr.xdrEncodeInt($size); ");
            }
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(decl.identifier);
            code.append("[$idx].xdrEncode(xdr); ");
            code.append("} }\n");
        } else {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append("xdr.xdrDecodeInt()");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            code.append(decl.identifier);
            code.append(" = new ");
            code.append(decl.type);
            code.append("[$size]; ");
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(decl.identifier);
            code.append("[$idx] = new ");
            code.append(decl.type);
            code.append("(xdr); ");
            code.append("} }\n");
        }
        return code.toString();
    }

    public static String checkForSpecials(String dataType) {
        if (globalIdentifiers.get(dataType) instanceof JrpcgenEnum) {
            return "int";
        }
        if ("opaque".equals(dataType)) {
            return "byte";
        }
        return dataType;
    }

    public static String checkForEnumValue(String value) {
        if (value.length() > 0) {
            if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '-') {
                return value;
            }
            Object id = globalIdentifiers.get(value);
            if (id != null && id instanceof JrpcgenConst) {
                JrpcgenConst c = (JrpcgenConst)id;
                if (c.enclosure == null) {
                    return c.value;
                }
                return String.valueOf(String.valueOf(c.enclosure).concat(String.valueOf("."))).concat(String.valueOf(c.identifier));
            }
        }
        return value;
    }

    public static void dumpStruct(JrpcgenStruct s) {
        PrintWriter out = jrpcgen.createJavaSourceFile(s.identifier);
        out.println(String.valueOf(String.valueOf("public class ").concat(String.valueOf(s.identifier))).concat(String.valueOf(" implements XdrAble {")));
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            JrpcgenDeclaration d = (JrpcgenDeclaration)decls.nextElement();
            out.print(String.valueOf(String.valueOf("    public ").concat(String.valueOf(jrpcgen.checkForSpecials(d.type)))).concat(String.valueOf(" ")));
            if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
                out.print("[] ");
            }
            out.println(String.valueOf(d.identifier).concat(String.valueOf(";")));
        }
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(s.identifier))).concat(String.valueOf("() {")));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(s.identifier))).concat(String.valueOf("(XdrDecodingStream xdr)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), true));
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), false));
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpUnion(JrpcgenUnion u) {
        JrpcgenUnionArm a;
        JrpcgenUnionArm a2;
        PrintWriter out = jrpcgen.createJavaSourceFile(u.identifier);
        out.println(String.valueOf(String.valueOf("public class ").concat(String.valueOf(u.identifier))).concat(String.valueOf(" implements XdrAble {")));
        out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public ").concat(String.valueOf(jrpcgen.checkForSpecials(u.descriminant.type)))).concat(String.valueOf(" "))).concat(String.valueOf(u.descriminant.identifier))).concat(String.valueOf(";")));
        boolean boolDescriminant = u.descriminant.type.equals("boolean");
        Enumeration arms = u.elements.elements();
        while (arms.hasMoreElements()) {
            a2 = (JrpcgenUnionArm)arms.nextElement();
            if (a2.element == null || a2.element.identifier == null) continue;
            out.print(String.valueOf(String.valueOf("    public ").concat(String.valueOf(jrpcgen.checkForSpecials(a2.element.type)))).concat(String.valueOf(" ")));
            if (!(a2.element.kind != 1 && a2.element.kind != 2 || a2.element.type.equals("String"))) {
                out.print("[] ");
            }
            out.println(String.valueOf(a2.element.identifier).concat(String.valueOf(";")));
        }
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(u.identifier))).concat(String.valueOf("() {")));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(u.identifier))).concat(String.valueOf("(XdrDecodingStream xdr)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, true));
        if (!boolDescriminant) {
            out.println(String.valueOf(String.valueOf("        switch ( ").concat(String.valueOf(u.descriminant.identifier))).concat(String.valueOf(" ) {")));
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a2 = (JrpcgenUnionArm)arms.nextElement();
                if (a2.value != null) {
                    out.println(String.valueOf(String.valueOf("        case ").concat(String.valueOf(jrpcgen.checkForEnumValue(a2.value)))).concat(String.valueOf(":")));
                } else {
                    out.println("        default:");
                }
                if (a2.element == null) continue;
                if (a2.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a2.element, true));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("if ( ").concat(String.valueOf(u.descriminant.identifier))).concat(String.valueOf(" == "))).concat(String.valueOf(jrpcgen.checkForEnumValue(a.value)))).concat(String.valueOf(" ) {")));
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, false));
        if (!boolDescriminant) {
            out.println(String.valueOf(String.valueOf("        switch ( ").concat(String.valueOf(u.descriminant.identifier))).concat(String.valueOf(" ) {")));
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                JrpcgenUnionArm a3 = (JrpcgenUnionArm)arms.nextElement();
                if (a3.value != null) {
                    out.println(String.valueOf(String.valueOf("        case ").concat(String.valueOf(jrpcgen.checkForEnumValue(a3.value)))).concat(String.valueOf(":")));
                } else {
                    out.println("        default:");
                }
                if (a3.element == null) continue;
                if (a3.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a3.element, false));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("if ( ").concat(String.valueOf(u.descriminant.identifier))).concat(String.valueOf(" == "))).concat(String.valueOf(jrpcgen.checkForEnumValue(a.value)))).concat(String.valueOf(" ) {")));
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpTypedef(JrpcgenDeclaration d) {
        PrintWriter out = jrpcgen.createJavaSourceFile(d.identifier);
        out.println(String.valueOf(String.valueOf("public class ").concat(String.valueOf(d.identifier))).concat(String.valueOf(" implements XdrAble {")));
        out.println();
        String paramType = jrpcgen.checkForSpecials(d.type);
        if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
            paramType = String.valueOf(paramType).concat(String.valueOf(" []"));
        }
        out.print(String.valueOf(String.valueOf("    public ").concat(String.valueOf(paramType))).concat(String.valueOf(" value;")));
        out.println();
        JrpcgenDeclaration dstar = null;
        try {
            dstar = (JrpcgenDeclaration)d.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("fatal: can not clone JrpcgenDeclaration");
        }
        dstar.identifier = "value";
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(d.identifier))).concat(String.valueOf("() {")));
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public ").concat(String.valueOf(d.identifier))).concat(String.valueOf("("))).concat(String.valueOf(paramType))).concat(String.valueOf(" value) {")));
        out.println("        this.value = value;");
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(d.identifier))).concat(String.valueOf("(XdrDecodingStream xdr)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, true));
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, false));
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpClasses() {
        Enumeration globals = globalIdentifiers.elements();
        while (globals.hasMoreElements()) {
            Object o = globals.nextElement();
            if (o instanceof JrpcgenEnum) {
                jrpcgen.dumpEnum((JrpcgenEnum)o);
                continue;
            }
            if (o instanceof JrpcgenStruct) {
                jrpcgen.dumpStruct((JrpcgenStruct)o);
                continue;
            }
            if (o instanceof JrpcgenUnion) {
                jrpcgen.dumpUnion((JrpcgenUnion)o);
                continue;
            }
            if (!(o instanceof JrpcgenDeclaration)) continue;
            jrpcgen.dumpTypedef((JrpcgenDeclaration)o);
        }
    }

    public static void dumpClientStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int size = versionInfo.procedures.size();
        for (int idx = 0; idx < size; ++idx) {
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            String paramType = jrpcgen.checkForSpecials(proc.parameterType);
            String resultType = jrpcgen.checkForSpecials(proc.resultType);
            out.println("    /**");
            out.println(String.valueOf(String.valueOf("     * Call remote procedure ").concat(String.valueOf(proc.procedureId))).concat(String.valueOf(".")));
            out.println("     * @param params Parameter(s) to the remote procedure call.");
            out.println("     * @return Result from remote procedure call.");
            out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
            out.println("     * @throws IOException if an I/O error occurs.");
            out.println("     */");
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public ").concat(String.valueOf(resultType))).concat(String.valueOf(" "))).concat(String.valueOf(proc.procedureId))).concat(String.valueOf("("))).concat(String.valueOf(paramType.equals("void") ? "" : String.valueOf(paramType).concat(String.valueOf(" params"))))).concat(String.valueOf(")")));
            out.println("           throws OncRpcException, IOException {");
            String xdrParams = jrpcgen.xdrBaseType(paramType);
            String params = "params";
            String xdrResult = jrpcgen.xdrBaseType(resultType);
            String result = "result";
            if (paramType.equals("void")) {
                out.println("        XdrVoid xparams = XdrVoid.XDR_VOID;");
                params = "xparams";
            } else if (xdrParams != null) {
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        ").concat(String.valueOf(xdrParams))).concat(String.valueOf(" xparams = new "))).concat(String.valueOf(xdrParams))).concat(String.valueOf("(params);")));
                params = "xparams";
            }
            if (resultType.equals("void")) {
                out.println("        XdrVoid xresult = XdrVoid.XDR_VOID;");
                result = "xresult";
            } else if (xdrResult != null) {
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        ").concat(String.valueOf(xdrResult))).concat(String.valueOf(" xresult = new "))).concat(String.valueOf(xdrResult))).concat(String.valueOf("();")));
                result = "xresult";
            } else {
                out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        ").concat(String.valueOf(resultType))).concat(String.valueOf(" result = new "))).concat(String.valueOf(resultType))).concat(String.valueOf("();")));
            }
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        client.call(").concat(String.valueOf(baseClassname))).concat(String.valueOf("."))).concat(String.valueOf(proc.procedureId))).concat(String.valueOf(", "))).concat(String.valueOf(params))).concat(String.valueOf(", "))).concat(String.valueOf(result))).concat(String.valueOf(");")));
            if (xdrResult != null) {
                if (!resultType.equals("void")) {
                    out.println(String.valueOf(String.valueOf("        return xresult.").concat(String.valueOf(resultType.toLowerCase()))).concat(String.valueOf("Value();")));
                }
            } else {
                out.println("        return result;");
            }
            out.println("    }");
            out.println();
        }
    }

    public static void dumpClient(JrpcgenProgramInfo programInfo) {
        int version = Integer.parseInt(((JrpcgenVersionInfo)programInfo.versions.elementAt((int)0)).versionNumber);
        int versionSize = programInfo.versions.size();
        for (int idx = 1; idx < versionSize; ++idx) {
            int anotherVersion = Integer.parseInt(((JrpcgenVersionInfo)programInfo.versions.elementAt((int)idx)).versionNumber);
            if (anotherVersion <= version) continue;
            version = anotherVersion;
        }
        String clientClass = jrpcgen.clientClass;
        if (clientClass == null) {
            clientClass = String.valueOf(String.valueOf(String.valueOf(baseClassname).concat(String.valueOf("_"))).concat(String.valueOf(programInfo.programId))).concat(String.valueOf("_Client"));
            System.out.println(String.valueOf("CLIENT: ").concat(String.valueOf(clientClass)));
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(clientClass);
        out.println("import java.net.InetAddress;");
        out.println();
        out.println("/**");
        out.println(String.valueOf(String.valueOf(" * The class <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> implements the client stub proxy")));
        out.println(String.valueOf(String.valueOf(" * for the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program. It provides method stubs")));
        out.println(" * which, when called, in turn call the appropriate remote method (procedure).");
        out.println(" */");
        out.println(String.valueOf(String.valueOf("public class ").concat(String.valueOf(clientClass))).concat(String.valueOf(" extends OncRpcClientStub {")));
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf("     * Constructs a <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> client stub proxy object")));
        out.println(String.valueOf(String.valueOf("     * from which the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program can be accessed.")));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(clientClass))).concat(String.valueOf("(InetAddress host, int protocol)")));
        out.println("           throws OncRpcException, IOException {");
        out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        super(host, ").concat(String.valueOf(baseClassname))).concat(String.valueOf("."))).concat(String.valueOf(programInfo.programId))).concat(String.valueOf(", "))).concat(String.valueOf(version))).concat(String.valueOf(", 0, protocol);")));
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf("     * Constructs a <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> client stub proxy object")));
        out.println(String.valueOf(String.valueOf("     * from which the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program can be accessed.")));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param port Port number at host where the remote program can be reached.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(clientClass))).concat(String.valueOf("(InetAddress host, int port, int protocol)")));
        out.println("           throws OncRpcException, IOException {");
        out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("        super(host, ").concat(String.valueOf(baseClassname))).concat(String.valueOf("."))).concat(String.valueOf(programInfo.programId))).concat(String.valueOf(", "))).concat(String.valueOf(version))).concat(String.valueOf(", port, protocol);")));
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf("     * Constructs a <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> client stub proxy object")));
        out.println(String.valueOf(String.valueOf("     * from which the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program can be accessed.")));
        out.println("     * @param client ONC/RPC client connection object implementing a particular");
        out.println("     *   protocol.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(clientClass))).concat(String.valueOf("(OncRpcClient client)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(client);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf("     * Constructs a <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> client stub proxy object")));
        out.println(String.valueOf(String.valueOf("     * from which the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program can be accessed.")));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param program Remote program number.");
        out.println("     * @param version Remote program version number.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(clientClass))).concat(String.valueOf("(InetAddress host, int program, int version, int protocol)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(host, program, version, 0, protocol);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println(String.valueOf(String.valueOf("     * Constructs a <code>").concat(String.valueOf(clientClass))).concat(String.valueOf("</code> client stub proxy object")));
        out.println(String.valueOf(String.valueOf("     * from which the ").concat(String.valueOf(programInfo.programId))).concat(String.valueOf(" remote program can be accessed.")));
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param program Remote program number.");
        out.println("     * @param version Remote program version number.");
        out.println("     * @param port Port number at host where the remote program can be reached.");
        out.println("     * @param protocol {@link org.acplt.oncrpc.OncRpcProtocols Protocol} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(clientClass))).concat(String.valueOf("(InetAddress host, int program, int version, int port, int protocol)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        super(host, program, version, port, protocol);");
        out.println("    }");
        out.println();
        for (int versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            JrpcgenVersionInfo versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpClientStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpServerStubMethodCall(PrintWriter out, JrpcgenProcedureInfo proc) {
        String paramType = jrpcgen.checkForSpecials(proc.parameterType);
        String xdrParams = jrpcgen.xdrBaseType(paramType);
        String xdrResult = jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(proc.resultType));
        String params = "";
        if (proc.parameterType.equals("void")) {
            out.println("                call.retrieveCall(XdrVoid.XDR_VOID);");
        } else if (xdrParams != null) {
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("                ").concat(String.valueOf(xdrParams))).concat(String.valueOf(" params = new "))).concat(String.valueOf(xdrParams))).concat(String.valueOf("();")));
            out.println("                call.retrieveCall(params);");
            params = String.valueOf(String.valueOf("params.").concat(String.valueOf(paramType.toLowerCase()))).concat(String.valueOf("Value()"));
        } else {
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("                ").concat(String.valueOf(paramType))).concat(String.valueOf(" params = new "))).concat(String.valueOf(paramType))).concat(String.valueOf("();")));
            out.println("                call.retrieveCall(params);");
            params = "params";
        }
        if (proc.resultType.equals("void")) {
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("                ").concat(String.valueOf(proc.procedureId))).concat(String.valueOf("("))).concat(String.valueOf(params))).concat(String.valueOf(");")));
            out.println("                call.reply(XdrVoid.XDR_VOID);");
        } else if (xdrResult != null) {
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("                ").concat(String.valueOf(xdrResult))).concat(String.valueOf(" result = new "))).concat(String.valueOf(xdrResult))).concat(String.valueOf("("))).concat(String.valueOf(proc.procedureId))).concat(String.valueOf("("))).concat(String.valueOf(params))).concat(String.valueOf("));")));
            out.println("                call.reply(result);");
        } else {
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("                ").concat(String.valueOf(proc.resultType))).concat(String.valueOf(" result = "))).concat(String.valueOf(proc.procedureId))).concat(String.valueOf("("))).concat(String.valueOf(params))).concat(String.valueOf(");")));
            out.println("                call.reply(result);");
        }
    }

    public static void dumpServerStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int procSize = versionInfo.procedures.size();
        for (int idx = 0; idx < procSize; ++idx) {
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            String params = "";
            if (!proc.parameterType.equals("void")) {
                params = String.valueOf(jrpcgen.checkForSpecials(proc.parameterType)).concat(String.valueOf(" params"));
            }
            String result = jrpcgen.checkForSpecials(proc.resultType);
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("    public abstract ").concat(String.valueOf(result))).concat(String.valueOf(" "))).concat(String.valueOf(proc.procedureId))).concat(String.valueOf("("))).concat(String.valueOf(params))).concat(String.valueOf(");")));
            out.println();
        }
    }

    public static void dumpServer(JrpcgenProgramInfo programInfo) {
        JrpcgenVersionInfo versionInfo;
        int versionIdx;
        String serverClass = jrpcgen.serverClass;
        if (serverClass == null) {
            serverClass = String.valueOf(String.valueOf(String.valueOf(baseClassname).concat(String.valueOf("_"))).concat(String.valueOf(programInfo.programId))).concat(String.valueOf("_ServerStub"));
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(serverClass);
        out.println("import org.acplt.oncrpc.server.*;");
        out.println();
        out.println("/**");
        out.println(" */");
        out.println(String.valueOf(String.valueOf("public abstract class ").concat(String.valueOf(serverClass))).concat(String.valueOf(" extends OncRpcServerStub implements OncRpcDispatchable {")));
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(serverClass))).concat(String.valueOf("()")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(0);");
        out.println("    }");
        out.println();
        out.println(String.valueOf(String.valueOf("    public ").concat(String.valueOf(serverClass))).concat(String.valueOf("(int port)")));
        out.println("           throws OncRpcException, IOException {");
        out.println("        info = new OncRpcServerTransportRegistrationInfo [] {");
        int versionSize = programInfo.versions.size();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("            new OncRpcServerTransportRegistrationInfo(").concat(String.valueOf(baseClassname))).concat(String.valueOf("."))).concat(String.valueOf(programInfo.programId))).concat(String.valueOf(", "))).concat(String.valueOf(versionInfo.versionNumber))).concat(String.valueOf("),")));
        }
        out.println("        };");
        out.println("        transports = new OncRpcServerTransport [] {");
        out.println("            new OncRpcUdpServerTransport(this, port, info, 32768),");
        out.println("            new OncRpcTcpServerTransport(this, port, info, 32768)");
        out.println("        };");
        out.println("    }");
        out.println();
        out.println("    public void dispatchOncRpcCall(OncRpcCallInformation call, int program, int version, int procedure)");
        out.println("           throws OncRpcException, IOException {");
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            out.print(versionIdx == 0 ? "        " : "        } else ");
            out.println(String.valueOf(String.valueOf("if ( version == ").concat(String.valueOf(versionInfo.versionNumber))).concat(String.valueOf(" ) {")));
            int procSize = versionInfo.procedures.size();
            out.println("            switch ( procedure ) {");
            for (int procIdx = 0; procIdx < procSize; ++procIdx) {
                JrpcgenProcedureInfo procInfo = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(procIdx);
                out.println(String.valueOf(String.valueOf("            case ").concat(String.valueOf(procInfo.procedureNumber))).concat(String.valueOf(": {")));
                jrpcgen.dumpServerStubMethodCall(out, procInfo);
                out.println("                break;");
                out.println("            }");
            }
            out.println("            default:");
            out.println("                call.failProcedureUnavailable();");
            out.println("            }");
        }
        out.println("        } else {");
        out.println("            call.failProcedureUnavailable();");
        out.println("        }");
        out.println("    }");
        out.println();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpServerStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpFiles() {
        jrpcgen.dumpConstants();
        jrpcgen.dumpClasses();
        for (int i = 0; i < programInfos.size(); ++i) {
            JrpcgenProgramInfo progInfo = (JrpcgenProgramInfo)programInfos.elementAt(i);
            if (!noClient) {
                jrpcgen.dumpClient(progInfo);
            }
            if (noServer) continue;
            jrpcgen.dumpServer(progInfo);
        }
    }

    public static void main(String[] args) {
        String arg;
        int argIdx;
        int argc = args.length;
        for (argIdx = 0; argIdx < argc && ((arg = args[argIdx]).length() <= 0 || arg.charAt(0) == '-'); ++argIdx) {
            if (arg.equals("-d")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing directory");
                    System.exit(1);
                }
                destinationDir = new File(args[argIdx]);
                continue;
            }
            if (arg.equals("-package") || arg.equals("-p")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing package name");
                    System.exit(1);
                }
                packageName = args[argIdx];
                continue;
            }
            if (arg.equals("-c")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing client class name");
                    System.exit(1);
                }
                clientClass = args[argIdx];
                continue;
            }
            if (arg.equals("-s")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing server class name");
                    System.exit(1);
                }
                serverClass = args[argIdx];
                continue;
            }
            if (arg.equals("-debug")) {
                debug = true;
                continue;
            }
            if (arg.equals("-nobackup")) {
                noBackups = true;
                continue;
            }
            if (arg.equals("-noclient")) {
                noClient = true;
                continue;
            }
            if (arg.equals("-noserver")) {
                noServer = true;
                continue;
            }
            if (arg.equals("-parseonly")) {
                parseOnly = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("jrpcgen version \"0.93.0\"");
                System.exit(1);
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                jrpcgen.printHelp();
                System.exit(1);
                continue;
            }
            if (arg.equals("--")) {
                ++argIdx;
                break;
            }
            System.out.println(String.valueOf("Unrecognized option: ").concat(String.valueOf(arg)));
            System.exit(1);
        }
        if (argIdx >= argc || argIdx < argc - 1) {
            jrpcgen.printHelp();
            System.exit(1);
        }
        String xfilename = args[argIdx];
        File xfile = new File(".", xfilename);
        if (baseClassname == null) {
            String name = xfile.getName();
            int dotIdx = name.lastIndexOf(46);
            baseClassname = dotIdx < 0 ? name : name.substring(0, dotIdx);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(xfilename);
        }
        catch (FileNotFoundException e) {
            System.out.println(String.valueOf("jrpcgen: can not open ").concat(String.valueOf(xfilename)));
            System.exit(1);
        }
        JrpcgenScanner scanner = new JrpcgenScanner(in);
        JrpcgenParser parser = new JrpcgenParser(scanner);
        globalIdentifiers.put("TRUE", new JrpcgenConst("TRUE", "true"));
        globalIdentifiers.put("FALSE", new JrpcgenConst("FALSE", "false"));
        try {
            Symbol sym = parser.parse();
            if (!parseOnly) {
                if (programInfos.size() <= 1) {
                    if (clientClass == null) {
                        clientClass = String.valueOf(baseClassname).concat(String.valueOf("Client"));
                    }
                    if (serverClass == null) {
                        serverClass = String.valueOf(baseClassname).concat(String.valueOf("ServerStub"));
                    }
                }
                jrpcgen.dumpFiles();
            }
        }
        catch (JrpcgenParserException pe) {
            System.out.println("jrpcgen: compilation aborted.");
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

