package ins.api;

import java.util.*;
import java.io.*;

/**
 * Describe class <code>ACLlist</code> here.
 * Basic ACL managment. it can query operations and recieve info on who is 
 * allowed
 * to perform them.
 *
 * @author <a href="mailto:jrfurman@mit.edu">Joshua Furman</a>
 * @version 1.0
 * @since 1.0
 */
public class ACLlist{
    private Hashtable aclTable; 

    public ACLlist(String aclFile) throws IOException, FileNotFoundException{
        aclTable = new Hashtable();
				//load crap from file and put into table
	loadFile(aclFile);
    }
		
    public ACLlist(){
	aclTable = new Hashtable();
				//empty constructor not much to do
    }
		
    public void loadFile(String aclFile) throws IOException, 
    FileNotFoundException{
				//use util.Properties
	File inputFile = new File(aclFile);
	FileInputStream in = new FileInputStream(inputFile);
	Properties prop = new Properties();
	prop.load(in);
	Enumeration ops = prop.propertyNames();
	while (ops.hasMoreElements()){
	    String ne = (String)(ops.nextElement());
	    System.out.println("Adding ACL's for operation: "+ne);
	    String s = (String)(prop.get(ne));
	    aclTable.put(ne.toUpperCase(),tokenize(s));
	}
    }
    private Vector tokenize(String s){
	StringTokenizer st = new StringTokenizer(s,",;| \t");
	Vector v = new Vector();
	while(st.hasMoreTokens()){
	    String curr = st.nextToken();
	    v.add(curr.toUpperCase());
	    System.out.println("\tGroup: "+ curr);
	}
        return v;
    }

		
    /**
     *<code>getPerms</code> returns a list of groups capable
     * of performing the given operation
     * 
     * @param op a <code>String</code> value, the operation we wish to perform
     * @param group a <code>String</code> value, the group who wishes to do the
     * op
     * @return a <code>boolean</code> value, true if allowed, false if not
     */
    public boolean  getPerms(String op, String group){

	Vector temp = (Vector)(aclTable.get(op.toUpperCase()));
	System.out.println("ACL looking up: "+op.toUpperCase()+
			   " and " + group + " got " + temp.toString());
	if(temp == null){
	    //no such op
	    return false;
	}

//  	if (((String)temp.get(0)) != group) {
//  	    System.err.println("tmp is " +((String)temp.get(0)).length() + ", grp is " +
//  			       group.toUpperCase().length());
//  	    System.err.println("tmp="+((String)temp.get(0))+"\n" +
//  			       "grp="+group.toUpperCase());
//  	    byte[] byte1 = ((String)temp.get(0)).getBytes();
//  	    byte[] byte2 = group.getBytes();

//  	    for (int i=0; i<byte1.length; i++)
//  		System.err.print(byte1[i]);
//  	    System.err.println();
//  	    for (int i=0; i<byte2.length; i++)
//  		System.err.print(byte2[i]);
//  	    System.err.println();
	    
//  	}
	
	return (temp.contains(group.toUpperCase()) || temp.contains("*"));
	
    }
    /**
     * <code>getGroupsforOp</code> returns a Vector of groups thst may perform
     * an operation
     *
     * @param op a <code>String</code> value, the op we want to lookup
     * @return a <code>Vector</code> value, the groups that may do 'op',null
     * if it doesn't exist
     */
    public Vector getGroupsForOp(String op){
	Object obj = aclTable.get(op.toUpperCase());
	if (obj == null){
	    return null;
	}else{
	    return (Vector)(((Vector)obj).clone());
	}
    }
}
