package ins.api;

import ins.namespace.*;
import ins.inr.*;
import java.io.*;
import java.util.*;

/** 
 * This file is a driver created to test the client API with
 * the INS system. Different commands can be typed in and 
 * executed to test the correct operation of the code.
 * HACK AS NECESSARY! :)
 *
 * All that needs to be set is the advertised name as a command line
 * parameter. e.g.
 *      java ins.api.AppTests [service=hi][vspace=test]
 * 
 * As a shortcut, if the name ARG does not start with "[", the name
 * will be constructed as [service=ARG][vspace=test].
 *      java ins.api.AppTests hi              (does the same as above)
 *
 * As a usage example, to test if anycast works, you could set 
 * up two AppTests, one with a command line parameter "a" and the
 * other with parameter "b" and then type at the console of "a":
 *
 *   sendMessage [service=a][vspace=test] [service=b][vspace=test] any hi
 *
 * @author jjlilley
 */

public class AppTests extends Application 
{

    public AppTests() throws Exception {
	super("127.0.0.1");
	this.enableSinglePeering();
    }


    public void receivePacket(Packet p) {
	System.out.println("/ Received Packet:\n"+p.toString());
    }


    public static void main(String args[]) {
	AppTests t1;
	try { t1= new AppTests();} 
	catch (Exception e) { System.out.println("Bad: "+e.toString());return;}
	
	if (args.length!=1) {
	    System.out.println
		("Requires a command line parameter for the name.");
	    System.out.println
		("Either enter the full intentional name, or, as a shortcut,");
	    System.out.println
		("just type in what the service will be in a vspace test.");
	    System.out.println("\t\t[service=X][vspace=test]");
	    return;
	}

	String nsstr = args[0];
	if (!nsstr.startsWith("["))
	    nsstr = "[service="+args[0]+"][vspace=test]";

	NameSpecifier ns = 
	    new NameSpecifier(nsstr);

	t1.startAnnouncer(new NameSpecifier[]{ns},new int[]{2}, 10000);
	System.out.println("announcing "+ns.toString());

	BufferedReader r = new BufferedReader
	    (new InputStreamReader(System.in));
	String response=null;


	while (true) {
	    try {
		response = r.readLine();
		StringTokenizer st = new StringTokenizer(response);
		
		if (st.hasMoreTokens()) {
		    String t = st.nextToken();
		    
		    if (t.equals("sendMessage")) {
			NameSpecifier ns1 =new NameSpecifier(st.nextToken());
			NameSpecifier ns2 =new NameSpecifier(st.nextToken());
			boolean toall =  (st.nextToken().equals("all"));
			String data = st.nextToken();
			System.out.println("/ sending message: "+
					   ns1.toString()+" "+ns2.toString()+
					   " "+(toall?"true":"false")+" "+
					   data);
			t1.sendMessage(ns1,ns2,toall,data.getBytes());
		    } else 

		    if (t.equals("sm")) {
			NameSpecifier ns2 =new NameSpecifier(st.nextToken());
			System.out.println("/ sending message: "+
					   ns.toString()+" "+ns2.toString()+
					   " "+(false?"all":"any")+" "+
					   "hey there");
			t1.sendMessage(ns,ns2,false,("hey there").getBytes());
		    } else 

		    if (t.equals("smm")) {
			NameSpecifier ns2 =new NameSpecifier(st.nextToken());
			System.out.println("/ sending message: "+
					   ns.toString()+" "+ns2.toString()+
					   " "+(true?"all":"any")+" "+
					   "hey there");
			t1.sendMessage(ns,ns2,true,("hey there").getBytes());
		    } else 

		    if (t.equals("addAnnouncement")) {
			NameSpecifier n1 =new NameSpecifier(st.nextToken());
			int ttl = Integer.parseInt(st.nextToken());
			t1.addAnnouncement(n1,ttl);
			System.out.println("/ addAnnouncement: "+
					   n1.toString()+" "+
					   Integer.toString(ttl));
		    } else 

		    if (t.equals("removeAnnouncement")) {
			NameSpecifier n1 =new NameSpecifier(st.nextToken());
			t1.removeAnnouncement(n1);
			System.out.println("/ removeAnnouncement: "+
					   n1.toString());
		    } else 

		    if (t.equals("addTCPEarlyBinding")) {

			int port = Integer.parseInt(st.nextToken());
			t1.addTCPEarlyBinding((short)port);
			System.out.println("/ addTCPEarlyBinding: "+
					   Integer.toString(port));
		    } else 

		    if (t.equals("suspendAnnouncer")) {
			t1.suspendAnnouncer();
			System.out.println("/ suspendAnnouncer: ");
		    } else 

		    if (t.equals("resumeAnnouncer")) {
			t1.resumeAnnouncer();
			System.out.println("/ resumeAnnouncer: ");
		    } else 

		    if (t.equals("getLocation")) {
			System.out.println("/ getLocation: ");
			System.out.println(t1.getLocation(1000));
		    } else 

		    if (t.equals("cleanUp")) {
			System.out.println("/ cleanUp: ");
			t1.cleanUp();			
			break;
		    } else 


		    if (t.equals("discoverNames")) {
			NameSpecifier n1 =new NameSpecifier(st.nextToken());
			boolean discoverFull = (st.hasMoreElements());
			System.out.println("/ discoverNames: "+n1.toString());
			NameSpecifier []nses=t1.discoverNames(n1,discoverFull);
			System.out.println(" results length: "+nses.length);
			for (int i=0; i<nses.length; i++) {
			    System.out.println(" "+i+") "+nses[i].toString());
			}
		    }
		    
		    else if (t.equals("getHostByiName")) {
			NameSpecifier n1 =new NameSpecifier(st.nextToken());
			boolean toall =  (st.nextToken().equals("all"));

			System.out.println("/ getHostByiName: "+n1.toString()+
					   (toall?"all":"any"));
			EarlyBindRecord [] eb = t1.getHostByiName(n1,toall);
			System.out.println(" results length: "+eb.length);
			for (int i=0; i<eb.length; i++) {
			    System.out.println(" "+i+") "+eb[i].toString());
			}
		    }
	    	
		}
	    } catch (Exception e) 
		
		{ System.out.println("error: "+e.toString()); 
		e.printStackTrace();}
	}
	

    }

	    

	   

}
