package ins.api;

import ins.inr.HostRecord;

/** 
 * EarlyBindRecord stores the results from an early bind call, 
 * namely the HostRecord of the entry, and the application-advertised
 * metric for the service.
 */

public class EarlyBindRecord {

    HostRecord hostRecord;
    int metric;

    public EarlyBindRecord(HostRecord hostRecord, int metric) {
	this.hostRecord = hostRecord;
	this.metric = metric;
    }

    /** @return HostRecord The underlying HostRecord */
    public HostRecord getHostRecord() { return hostRecord; }

    /** @return int The underlying metric */
    public int getMetric() { return metric; }

    /** 
     * Two EarlyBindRecords are equal if and only if their 
     * underlying HostRecords are equal. The metric is not
     * counted in this.
     */
    public boolean equals(Object o) {
	if ((o == null) || !(o instanceof EarlyBindRecord)) return false;

	EarlyBindRecord ebr = (EarlyBindRecord) o;
	return (hostRecord.equals(ebr.hostRecord));
    }

    /** Returns the EarlyBindRecord's hash code. */
    public int hashCode() {
	return hostRecord.hashCode();
    }
	
    public String toString() {
	return ("EarlyBindRecord { metric: "+Integer.toString(metric)+
		" hostRecord: "+(hostRecord==null?"null":hostRecord.toString())
		+" } ");
    }

}
