package ins.api;

import java.net.*;

/**
 * This class is merely a convenience class for holding the information 
 * necessary to contact a node.
 * 
 * @author Anit Chakraborty
 */

public class InetAddressPort
{
    public InetAddress addr;
    public int port;
    public long expirationTime;


    // CONSTRUCTORS
    /**
     * Creates a new new InetAddressPort.  
     * This class holds is a InetAddress and Port so we can hash it
     * as well as a ttl, which is infinite for this constructor
     * @param addr The InetAddress of the node.
     * @param port The port of the node.
     */
    public InetAddressPort (InetAddress addr, int port) {
	this.addr = addr;
	this.port = port;
	expirationTime = Long.MAX_VALUE;
    }	

    /**
     * Creates a new new InetAddressPort.  
     * all this class holds is a InetAddress and Port so we can hash it
     * @param addr The InetAddress of the node.
     * @param port The port of the node.
     * @param ttl  The time left to live in ms. Protected from overflow
     */
    public InetAddressPort (InetAddress addr, int port, long ttl) {
	this.addr = addr;
	this.port = port;
	expirationTime = (ttl==Long.MAX_VALUE)? 
	    Long.MAX_VALUE : System.currentTimeMillis()+ttl;
    }	

    /** Returns whether the entry has expired */
    public boolean isExpired() 
    { 
	return System.currentTimeMillis()>expirationTime; 
    }


    /* This hashcode does not consider the ttl field in the 
       comparisons */
    public int hashCode () {
	if (addr!=null) 
	    return addr.hashCode()+port;
	else return port;
    }

    /* This equals does not consider the ttl field in the 
       comparisons */
    public boolean equals(Object obj) {
	if (obj==null) return false;
	if (!(obj instanceof InetAddressPort)) return false;
	if ( ((InetAddressPort)obj).port != port ) return false;
	if (addr == null) {
	    if ( ((InetAddressPort)obj).addr == null) return true;
	    else return false;
	}
	return addr.equals( ((InetAddressPort)obj).addr);
    }

    public String toString() {
	return (addr==null?"null":addr.toString())+":"+Integer.toString(port)+
	    "<TTL:"+(expirationTime==Long.MAX_VALUE?"INFINITE":
		     Long.toString(expirationTime-System.currentTimeMillis()))+
	    ">";
    }
	
}
