package ins.api;

import ins.inr.*;
import ins.namespace.*;
import java.util.*;
import java.io.IOException;
import java.net.*;

/**
 * Based on the original NameAnnouncer
 * Advertises pairs of Name-Specs/Host-Records
 * instead of one Host-Record with many Name-Specs
 * @author Magdalena Balazinska
 */

public class MultiNameAnnouncer extends NameAnnouncer 
{
    HostRecord hr = null; // We don't want to use this attribute from the parent
    HostRecord multiHR[];
    
    public MultiNameAnnouncer (Application app, NameSpecifier nsa[],
			       int metric[], HostRecord[] multihr, 
			       int announcement_period) {
	
	super(app,announcement_period);
	multiHR = new HostRecord[multihr.length];

	// +5 added as in NameAnnouncer class
	this.nannouncements = new NameAnnouncement[nsa.length+5];
	this.ns = new NameSpecifier[nsa.length + 5];
	this.arrlength = nsa.length;

	for (int i = 0; i < multihr.length; i ++) { 
	    this.ns[i] = nsa[i];
	    this.multiHR[i] = multihr[i];
	    nannouncements[i] = createNameAnnouncement(nsa[i], metric[i], multihr[i],
						       NameUpdate.ADD_NAME,
						       sleep_time*2);
	}
	running = true;
	start();	

    }


    /**
     * Adds TCP early binding to all host-records
     */
    void addTCPEarlyBinding(short tcpport)  {
	for (int i = 0; i < multiHR.length; i ++) {
	    multiHR[i].addTransport("TCP", tcpport);
	    changeAnnouncedHostRecord(multiHR[i]);
	}
    }

    /**
     * Adds TCP early binding to a single host-record
     */
    void addTCPEarlyBinding(short tcpport, HostRecord hr)  {
	for (int i = 0; i < multiHR.length; i ++) {
	    if ( multiHR[i].equals(hr)) {
		multiHR[i].addTransport("TCP", tcpport);
		changeAnnouncedHostRecord(i, multiHR[i]);
	    }
	}
    }

    /**
     */
    void changeAnnouncedHostRecord(int index, HostRecord hr) 
    {
	synchronized(lock) {
	    multiHR[index] = hr;
	    nannouncements[index] = createNameAnnouncement (ns[index], 
							    nannouncements[index].getAppMetric(),
							    hr,NameUpdate.ADD_NAME, 
							    sleep_time*2);
	}
    }
    
    
    /**
     * See class NameAnnouncer for detailed explanations
     */
    protected NameAnnouncement createNameAnnouncement(NameSpecifier ns, int metric, 
						      byte updatetype, int ttl) {
	return null;
    }

    protected NameAnnouncement createNameAnnouncement(NameSpecifier ns, int metric, 
						      HostRecord hr,
						      byte updatetype, int ttl) {
	
	NameUpdate name_update;
	byte[] name_update_bytes;
	NameSpecifier sourceNS, routingNS;
	
	routingNS = new NameSpecifier(new String("[control-msg=announcement"));
	StringBuffer str = new StringBuffer();
	str.append("[host = ");
	str.append(app.localhost.getHostAddress());
	str.append("][UDPport = ");
	str.append(app.port);
	str.append("]");
	
	sourceNS = new NameSpecifier(str.toString());
	name_update = new NameUpdate(ns, metric, 0, 0, hr, announcer,
				     updatetype, ttl);	
	name_update_bytes = name_update.toBytes();
	Packet packet = new Packet(sourceNS, routingNS, 
				   Packet.toAll,
				   name_update_bytes);

	// We need to use the default vspace, because vspaces
	// are very tightly coupled to the rest of original
	// application functionality
	String vspace = this.app.getDefaultVspace();
	
	byte[] bytestosend = packet.toBytes();
	return new NameAnnouncement(bytestosend,vspace);
    }

    
    protected void addAnnouncement(NameSpecifier ns, int metric) { 
    }

    protected void addAnnouncement(NameSpecifier ns, int metric, HostRecord hr) {	
	NameAnnouncement na;
	na = createNameAnnouncement(ns, metric, hr, NameUpdate.ADD_NAME, 
				    sleep_time*2);
	synchronized(lock){
	    addAnnouncement (ns, na, metric);
	}
    }

 
    protected void removeAnnoucement(NameSpecifier ns, HostRecord hr) {
	int i;
	synchronized (lock){
	    for (i = 0 ; i < this.arrlength; i++) {
		if (this.ns[i].equals(ns) && hr.equals(multiHR[i]) ){
		    break;
		}
	    }
	    
	    //now copy everything back by one.
	    this.arrlength --;
	    for (;i < this.arrlength; i++) {
		this.ns[i] = this.ns[i+1];
		this.nannouncements[i] = this.nannouncements[i+1];
	    }
	}
	sendNegativeAnnouncement(ns,hr);
    }

    public void sendExpiringAnnouncement(NameSpecifier ns, HostRecord hr, int ttl)
    {
	NameAnnouncement na = 
	    createNameAnnouncement(ns, 5, hr, NameUpdate.ADD_NAME, ttl);

	if (na == null) return;

	DatagramPacket dp = na.produceDatagramPacket(this);
	if (dp == null) return;

	try {
	    app.sendDatagramPacket(dp);
	} catch (IOException e) { 
	    app.printStatus("...ah! could not make it!"); 
	} 
    }

    /** 
     * Sends a REMOVE_NAME announcement for a namespecifier
     */
    public void sendNegativeAnnouncement(NameSpecifier ns, HostRecord hr) {

	NameAnnouncement na = 
	    createNameAnnouncement(ns, 5, hr, NameUpdate.REMOVE_NAME, 
				   sleep_time*2);
	if (na == null) return;
	
	DatagramPacket dp = na.produceDatagramPacket(this);
	if (dp == null) return;

	app.printStatus("Sending negative announcement to inr");
	try {
	    app.sendDatagramPacket(dp);
	} catch (IOException e) { 
	    app.printStatus("...ah! could not make it!"); 
	} 
    }
    
 
    

}
