package ins.api;

import ins.inr.*;
import ins.namespace.*;
import java.net.*;
import java.io.*;
import java.util.Vector;

/**
 * The ReceiveManager is a thread that basically receives packets from the INR.
 * The reason we have a thread take care of this is that there are some packets
 * that the ClientLib machinery needs, there are some packets that need
 * to be dropped, and there are some packets that aren't 
 * 
 * @author Anit Chakraborty
 */

public class ReceiveManager extends Thread
{
    Application app;
    //    private Object lock = new Object();
    //private Object readlock = new Object();
    private Object location_lock = new Object();
    
    static Attribute control_msg_attribute = 
	new Attribute("control-msg");
    static Value discoverVal = new Value("discovery");
    static Value earlybindVal = new Value("early-binding");
    static Value announcementVal = new Value("announcement");
    static Value discoverReplyVal = new Value("discovery-reply");
    static Value earlybindReplyVal = new Value("early-binding-reply");

    // TwineResolvers send incomplete answers sometimes
    static Value discoverIncompleteReplyVal = new Value("discovery-incomplete-reply");
    static Value earlybindIncompleteReplyVal = new Value("early-binding-incomplete-reply");


    // for control packet waiting
    Vector ctrlWaiting = new Vector();
    Packet ctrlPacket = null;

    boolean rmRunning = true; // turned off to dispose of the thread
    
    /**
     * When this is true, the next packet will be sent to the Application!
     */
    //boolean node_want_notify = false;
    //DatagramPacket nodepacket = null;
    boolean freshPacket = false;
    boolean done = false;
    
    InetAddress localhost = null;

    boolean want_name_updates = true;
    
        
        
    public ReceiveManager (Application app) throws UnknownHostException {
	this.app = app;	
	this.localhost = InetAddress.getLocalHost();
	this.start();
    }
    
    /**
     * This will loop over and over and receive packets.  As packets
     * come in, it determines who needs the Packet.  If the application
     * is to receive the packet, it will send it up the Application,
     * otherwise it will call the appropriate method in Application to
     * handle it.
     */
    public void run () {
	try {
	    app.socket.setSoTimeout(500);	
	}
	catch (SocketException e) {}
	
	// you don't need to allocate a new buffer every time,
	// but should allocate a new DatagramPacket every time
	byte[] buffer = new byte[65536]; // arbitrary choice
	
	while (rmRunning) {
	    
	    DatagramPacket dpacket = new DatagramPacket(buffer, buffer.length);
	    boolean gotPacket = true;
	    
	    try {
		app.socket.receive(dpacket);
	    } catch (InterruptedIOException f ) {
		gotPacket = false;	  
	    } catch (IOException e) {
		// Connection refused, but can't tell which one 
		// it's coming from
		e.printStackTrace();
		System.out.println(e.getMessage());
	    } 
	    if (gotPacket){ //if we actually got a packet, try to handle it
		     //otherwise just do it over again!
		     //now we need to see where the next packet should go to!
		processPacket(dpacket);

	    }
	}

	System.out.println("exiting rm thread");
    }
    

    /** Processes each received packet */
    protected void processPacket(DatagramPacket dpacket) {

	// now check to see if this is a packet and discard non-packets
	Packet p = null;
	try	{
	    p = new Packet(dpacket.getData(), dpacket.getLength());
	} catch (Exception e) {
	    p=null;
	}
	
	if (p != null) {  
	    // if p was still null it was garbage	
	    //let's check if its a routing message
	    AVelement elem = p.dNS.getAVelement(control_msg_attribute);
	    
	    if (elem == null) {
		// these are passed to the application
		//app.printStatus("Received packet from:" +
		//		dpacket.getAddress() + " port:" +
		//		dpacket.getPort());
		
		try {
		    app.receivePacket(p);	
		} catch (Exception e) {
		    //for any exception we ignore it, report it and 
		    // continue
		    app.printStatus 
			("Application threw exception processing "+
			 "message:"+e.getMessage());
		    e.printStackTrace();
		}
	    } // ...if (elem == null)
	    else {  // we have a control message
		processControlMessage(p, elem);
	    }
	}
    }




    /** 
     * Sends a packet with a given sequence number and waits for a reply.
     * Used for earling binding and name discovery requests.
     */
//     Packet waitForReply(Packet msg, int sequenceNo, int timeout) 
//     {
//   	Integer i = new Integer(sequenceNo);
//   	ctrlWaiting.addElement(i);
//   	Packet p = null;
//   	if (app.sendMessage(msg)) { 
//  	    try { synchronized (i) { i.wait(timeout); } }
//  	    catch (InterruptedException e) { ; }
//  	    p = ctrlPacket;
//  	    ctrlPacket = null;
//   	} 
//   	ctrlWaiting.removeElement(i);
//   	//System.out.println("vector size on exit: "+ctrlWaiting.size()+
//   	//		   " rep: "+ctrlWaiting.toString());
//   	return p; 
//      }
    
     /** 
     * Sends a packet with a given sequence number and waits for a reply.
     * Used for earling binding and name discovery requests.
     * Modified by Magdalena Balazinska.
     * Changed the locking to avoid the race condition from the previous
     * version of this method
     */
    Packet waitForReply(Packet msg, int sequenceNo, int timeout) 
    {
 	Integer i = new Integer(sequenceNo);
 	ctrlWaiting.addElement(i);
 	Packet p = null;
 	try { 
 	    synchronized(i) {
 		if (app.sendMessage(msg))
 		    i.wait(timeout); 
 	    }
 	} catch (InterruptedException e) { }
 	p = ctrlPacket;
 	ctrlPacket = null;
 	ctrlWaiting.removeElement(i);
 	return p; 
    }
    
        
    protected void processControlMessage(Packet p, AVelement elem) {

	System.out.println("got control message");

	if (elem.getValue().equals(announcementVal)) {
	    // we for the most part don't get these anyway
	    app.printStatus("Throwing away announcement");	

	} else if ( supportedControlMessage(elem) ) { 

	    if (p.data.length>=4) {
		int sequenceNo = Conversion.extract32toInt(p.data, 0);
		Integer i=new Integer(sequenceNo);
		int ind = (ctrlWaiting.indexOf(i));
		if (ind>-1) { 
		    ctrlPacket=p;
		    Object o = ctrlWaiting.elementAt(ind);
		    synchronized (o) {
			o.notifyAll(); 
		    }
		} else {
		    app.printStatus("Nobody was waiting for #"+i.toString());
		}
	    }

	}
    }    
    

    protected boolean supportedControlMessage(AVelement elem) {

	return 
	    ( elem.getValue().equals(discoverReplyVal) 
	    || elem.getValue().equals(earlybindReplyVal) 
	    || elem.getValue().equals(discoverIncompleteReplyVal) 
	    || elem.getValue().equals(earlybindIncompleteReplyVal)); 
    
    }

    

}
