package ins.api;

import ins.inr.*;
import ins.namespace.*;

import java.net.*;
import java.io.*;
import java.util.*;
import java.awt.*;
					
/**
 * Simple base class for applications that interact with Twine resolvers. 
 * It uses the features of a Twine resolver and it avoids the mandatory 
 * use of vspaces. The "defaultVspace" is only used to communicate with
 * a DSR (if used). It allows to preserve compatibility with the original
 * version of the DSR.
 * 
 * 
 * @author Magdalena Balazinska
 */

public class TwineApp extends Application {

	
    /** 
     * Creates a new Application The application listens on a random
     * port and uses standard DNS
     * bootstrapping techniques to locate the DSR.
     */
    public TwineApp() throws Exception 
    {
	super();
    }

    /**
     * Creates a new Application with the DSR pre-specified.
     * @param dsr_name The name of the machine that runs the DSR 
     * we will be contacting.
     */
    public TwineApp (String dsr_name) throws Exception 
    {
	super(dsr_name);
    }

    /**
     * Creates a new Application that peers to a single, specific INR
     * and does no DSR communication.
     * @param inrname name of INR
     * @param inrport port of INR
     */    
    public TwineApp (String inrname, int inrport)
	throws Exception
    {
	super(inrname,inrport);
    }
    
   
   /**
    * TwineApp doesn't use vspaces in requests issued by
    * applications.
    */
    protected NameSpecifier addVSpace(NameSpecifier ns) {
	return ns;
    }
}
