package ins.api;

import ins.inr.*;
import ins.namespace.*;

import java.net.*;
import java.io.*;
import java.util.*;
import java.awt.*;
					
/**
 * Twine application using the MultiNameAnnouncer instead of a normal
 * announcer.
 * @author Magdalena Balazinska
 */

public class TwineMultiApp extends TwineApp {

    public TwineMultiApp() throws Exception {
	super();
    }

    public TwineMultiApp (String dsr_name) throws Exception {
	super(dsr_name);
    }

    public TwineMultiApp (String inrname, int inrport) throws Exception {
	super(inrname,inrport);
    }

    /**
     */
    public void startAnnouncer(NameSpecifier source[], HostRecord hr[]) {
	
	if (name_announcer == null) {

	    int [] metrics = new int[source.length];
	    for (int i=0; i<metrics.length; i++)
		metrics[i] = NameAnnouncer.DEFAULT_METRIC;
	    name_announcer = new MultiNameAnnouncer(this, source, metrics, hr, 
						    NameAnnouncer.DEFAULT_PERIOD);
	} else {
	    for (int i=0; i<source.length; i++) 
		((MultiNameAnnouncer)name_announcer).addAnnouncement
		    (source[i], NameAnnouncer.DEFAULT_METRIC, hr[i]);
	}
    }

    /**
     */
    public void startAnnouncer(NameSpecifier source[], int metric[], HostRecord hr[], int period) {

	if (name_announcer == null) {
	    name_announcer = new MultiNameAnnouncer(this, source, metric, hr, period);

	} else {
	    for (int i=0; i<source.length; i++) 
		((MultiNameAnnouncer)name_announcer).addAnnouncement(source[i], metric[i], hr[i]);
	}
    }

    
    /**
     */
    public void addTCPEarlyBinding(short tcpport) {

	if (name_announcer == null) return;
	this.name_announcer.addTCPEarlyBinding(tcpport);
	this.name_announcer.cycleThread();
	
    }
    
    /**
     */
    public void sendExpiringAnnouncement(NameSpecifier ns, HostRecord hr, int ttl)
    {
	if (name_announcer != null) 
	    ((MultiNameAnnouncer)name_announcer).sendExpiringAnnouncement(ns, hr, ttl);
	else 
	    printStatus("Implementation ERROR: sendExpiringAnnouncement "+
			"requires startAnnouncer to be called");
    }

    /**
     */
    public void addAnnouncement(NameSpecifier ns, int metric, HostRecord hr)
    {
	if (name_announcer!=null)
	    ((MultiNameAnnouncer)name_announcer).addAnnouncement(ns, metric,hr);
    }	
    
    /**
     */
    public void removeAnnouncement(NameSpecifier ns, HostRecord hr) {
	if (ns != null && name_announcer!=null) {
	    ((MultiNameAnnouncer)name_announcer).removeAnnoucement(ns,hr);
	}	
    }
}
