package camera;

import java.awt.Canvas;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public class Monitor extends Canvas
{
    Image img;
    MediaTracker tracker;
    int frmWidth, frmHeight;

    public Monitor()
    {
	tracker = new MediaTracker(this);
    }
	
    public void paint(Graphics g) {
	// Clear the canvas
	// g.setColor(Color.white);
	// g.fillRect(0,0,frmWidth,frmHeight);

	if (tracker.statusID(0,false) == MediaTracker.COMPLETE) {
	    g.drawImage(img, 0, 0, this);
	} else {
	    g.setColor(Color.blue);
	    //g.fillRect(0,0,399,249);
	    g.fillRect(0,0,159,119);
	    g.setColor(Color.black);
	    g.setFont(new Font("Helvetica", Font.BOLD, 12));
	    g.drawString("No Picture", 50, 60);
	}
    }
	
    public void update(Graphics g) {
	paint(g);
    }
	
    public Dimension getMinimumSize() {
	return new Dimension(160,120);
    }

    public Dimension getPreferredSize() {
	return getMinimumSize();
    }

    public synchronized void updateImage(byte[] imgByte) {
	// Get rid of the old image.
	if (img != null) {
	    tracker.removeImage(img);
	    img.flush();
	}
		
	// Create the new image and wait for it.
	img = getToolkit().createImage(imgByte);
	tracker.addImage(img, 0);
	try {
	    tracker.waitForID(0);
	} catch (InterruptedException e) {
	    System.out.println("Interrupted: " + e.getMessage());
	}

	if (tracker.isErrorAny()) {
	    System.out.println("Error in creating image");
	} else {
	    repaint();
	}
    }
}
