package camera;

import java.awt.BorderLayout;					 
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class ReceiverFrame extends Frame
    implements ActionListener
{
    Monitor monitor;
    Receiver receiver;
    Button updateButton;
    Button subscribeButton;
    Button unsubscribeButton;

    public ReceiverFrame(Receiver r, String subtitle) 
    {
	receiver = r;

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {		
		setVisible(false);
		setEnabled(false);
		dispose();

		receiver.cleanUp();
            }
        });

	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.BOTH;
	setLayout(gridbag);

	monitor = new Monitor();
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(monitor, c);
	add(monitor);

	updateButton = new Button("Update");
        updateButton.addActionListener(this);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(updateButton, c);
	add(updateButton);

	subscribeButton = new Button("Subscribe");
        subscribeButton.addActionListener(this);
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(subscribeButton, c);
	add(subscribeButton);

	unsubscribeButton = new Button("Unsubscribe");
        unsubscribeButton.addActionListener(this);
	unsubscribeButton.setEnabled(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(unsubscribeButton, c);
	add(unsubscribeButton);

	// setSize(frameWidth, frameHeight);
	setResizable(false);
	setTitle("Camera: " +subtitle);
	pack();
	setVisible(true);
    }	

    public void updateImage(byte[] source)
    {
	monitor.updateImage(source);
    }							

    public void actionPerformed(ActionEvent ae)
    {
	String command = ae.getActionCommand();

	if (command.equals("Update")) {
	    doUpdate();
	} else if (command.equals("Subscribe")) {
	    doSubscribe();
	} else if (command.equals("Unsubscribe")) {
	    doUnsubscribe();
	}
    }

    public void doUpdate()
    {
	receiver.sendRequest();
    }

    public void doSubscribe()
    {
	unsubscribeButton.setEnabled(true);
	subscribeButton.setEnabled(false);
	receiver.subscribe();
    }

    public void doUnsubscribe()
    {
	subscribeButton.setEnabled(true);
	unsubscribeButton.setEnabled(false);
	receiver.unsubscribe();
    }

    //    class WindowEventHandler extends WindowAdapter
    //{
    //	public void windowClosing(WindowEvent evt)
    //	{
    //	    // Destroy the window.
    //	    dispose();
    //	    System.exit(0);
    //	}
    //}

}
