package floorplan;

import ins.api.*;
import ins.inr.*;
import ins.namespace.*;
import java.net.InetAddress;

/**
 * The Echoer is a really simple "application" -- it starts up and 
 * then sends a single, 0-byte packet to the name-specifier of choice.
 * It is intended to "turn on" an application, but not much else.
 */

public class Echoer extends Application
	implements Runnable
{
    // VARIABLES
    NameSpecifier sourceNS, destNS;
    
    // CONSTRUCTORS
    public Echoer(String [] args) throws Exception
    {
	super();
	init(args);
    }

    public Echoer(String dsrname, String [] args) 
	throws Exception
    {
	super(dsrname);
	init(args);
    }

    public void init(String [] args) throws Exception
    {
	String hostname;

	try {
	    hostname = InetAddress.getLocalHost().getHostName();
	} catch (java.net.UnknownHostException e) {
	    hostname = "unknown";
	}

	// Use the DNS name as the node attribute, if available.	
	sourceNS = new NameSpecifier("[service=echoer]"+
				     "[node=" + hostname + "]");
	destNS = new NameSpecifier(args[0]);
	new Thread(this).start();
    }

    
    /** 
     * The run function for the main thread -- no loop or anything...
     */
    public void run()     
    {
	sendMessage(sourceNS, destNS, new byte[0]);
    }

    public static void main(String args[])
    {
	try { new Echoer("127.0.0.1", args); }
	catch (Exception e) { e.printStackTrace(); }
    }

}
