package hello;
import ins.api.*;
import ins.namespace.*;
import ins.inr.Packet;
import java.io.*;

public class HelloCli extends SecureApp {

    public static final String keyprefix = "clikeyfile";

    NameSpecifier ourName = new NameSpecifier("[service=hellocli][vspace=wind][op=hello]");
    NameSpecifier servName;
    // constructors
    
    public HelloCli(String keyprefix) throws Exception {
      	super(null, false, keyprefix); init();
    }
    
    public HelloCli(String dsrname, String keyprefix) throws Exception {
	super(null, false, keyprefix, dsrname);
	init();
    }

    public HelloCli(String inrname, int inrport, String keyprefix)
	throws Exception { 
	super(null, false, keyprefix, inrname, inrport);
	init();
    }


    // common init routine to start the name announcer
    void init() {
        // start announcing ourselves to the system
	startAnnouncer(new NameSpecifier[]{ ourName }); 
		
        //discover the name of our server
//  	NameSpecifier[] ns = discoverNames(new
//  	    NameSpecifier("[service=hello][vspace=test]"));
//  	servName = ns[0];
	servName = new NameSpecifier("[service=hello][vspace=wind][group=61337749927541422376238073610434650711341502519629251355895508262086379307371:72234469145070839385182367648059200400426877218784883639080522901986499135319]");

	System.out.println("Client Started!");
	System.out.println("Client: found server: "+servName.toString());
    }


    // sends a "hello" message through INS late-binding to ourselves
    void sendHello() {       
        sendMessage(ourName, servName, "hello world".getBytes());
    }

    // Called whenever a packet is received
//      public void receivePacket(Packet p) {
//          System.out.println(new String(p.data));
//      }

    public static void main(String [] args) throws Exception {

	if (args.length < 2) {
	    System.err.println("Usage: java hello.HelloCli <dsrname> <keyfile-prefix>");
	    System.exit(0);
	}
	
        HelloCli h = new HelloCli(args[0], args[1]);

	
	// send a test message whenever we receive a carriage return
	BufferedReader br =
            new BufferedReader(new InputStreamReader(System.in));
        while (br.readLine()!=null)
            h.sendHello();
    }
}
