package hello;

import ins.api.*;
import ins.namespace.*;
import ins.inr.Packet;
import java.io.*;

public class HelloServ extends SecureApp{

    public static final String keyprefix = "servkeyfile";
    public static final String aclfilename = "aclfile";

    NameSpecifier ourName = new NameSpecifier("[service=hello][vspace=wind]");

    // constructors

    public HelloServ(String keyprefix, String aclfilename) throws Exception {
	super(aclfilename, true, keyprefix);
	helloInit();
    }

    public HelloServ(String dsrname,
		     String keyprefix, String aclfilename) throws Exception {
	super(aclfilename, true, keyprefix, dsrname);
	helloInit();
    }

    public HelloServ(String inrname, int inrport,
		     String keyprefix, String aclfilename) throws Exception { 
        super(aclfilename, true, keyprefix, inrname, inrport);
	helloInit();
    }


    // common init routine to start the name announcer
    void helloInit() {
        // start announcing ourselves to the system
        startAnnouncer(new NameSpecifier[]{ ourName }); 
    }


      
    // Called whenever a packet is received
    public void respondToPacket(Packet p) {
        System.out.println(new String("Server got packet: "+p.data));
    }

    public static void main(String [] args) throws Exception {

	if (args.length != 3) {
	    System.err.println("Usage: java hello.HelloServ <dsrname> <keyfile-prefix> <aclfile>");
	    System.exit(0);
	}

        HelloServ h = new HelloServ(args[0], args[1], args[2]);
    }

}
