package metadatagenerator;

import joeshmoe.mpeg.*;
import ins.namespace.*;
import java.io.*;
import java.util.*;

/**
 * MpegMetaDataExtractor.java
 * 
 * Creates name-specifiers from mp3 tags
 * <br>
 * This class requires the mpegjava package
 * available at: http://www.joeshmoe.com/mpegjava/
 * <br>
 * Created: Fri Sep 21 2001 <br>
 * Modified: $Id: MpegMetaDataExtractor.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 *
 */
public class MpegMetaDataExtractor {

    public MpegMetaDataExtractor() {
    }

    /**
     * This method reads an mpeg file, extracts the header
     * and parses the meta data. 
     * @param fileName The name of the mp3 file 
     * @return The namespecifier discribing the mpeg file
     */
    public NameSpecifier extractDescrFromFile(String fileName) {

	if ( !fileName.endsWith("mp3") )
	    return null;

	try {
	    File file = new File(fileName);
	    ID3Tagger tagger = new ID3Tagger();
	    ID3Tag tag = tagger.readTag(file);
	    String name = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length());
	    //StringBuffer nsSB = new StringBuffer("[file-name="+name+"][file-type=mp3]");
	    StringBuffer nsSB = new StringBuffer("[file-name="+name+"]");
	    if ( tag != null) {
		GenreLookup gl = new GenreLookup();
		if ( checkValid(tag.getAlbum()) )
		    add(nsSB,"album",tag.getAlbum());
		if (  checkValid(tag.getArtist()) )
		    add(nsSB,"artist",tag.getArtist());
		if ( checkValid(tag.getComment()) )
		    add(nsSB,"comment",tag.getComment());
		if (( tag.getGenreID() == -1))
		    add(nsSB,"genre",gl.getGenreByID(tag.getGenreID()));
		if ( checkValid(tag.getSong()) )
		    add(nsSB,"title",tag.getSong());
		if ( checkValid(tag.getYear()) )
		    add(nsSB,"year",tag.getYear());
	    }
	    // For now, I only want files that have a header
	    else {
		return null;
	    }
	    NameSpecifier ns = new NameSpecifier(nsSB.toString());
	    return ns;

	} catch ( FileNotFoundException e ) {
	    System.err.println("mp3 file " + fileName + " not found");
	    return null;
	} catch ( IOException e ) {
	    System.err.println("IOException reading file " + fileName);
	    return null;
	}
	
    }


    /**
     * Sometimes tags contain caracters that make the Name-Specifier generation fail
     */
    public  boolean checkValid(String value) {  
	if (( value.indexOf('[') == -1 ) && ( value.indexOf('=') == -1 ))
	    return true;
	else
	    return false;
    }

    /**
     * Add attribute-value pairs to string making-up name-specifier
     */
    protected void add(StringBuffer dest, String attribute, String value) {
	
	if ( ( value != null ) && ( value.length()!=0 ) ) {
	    StringTokenizer st = new StringTokenizer(value);
	    while (st.hasMoreTokens()) {
		String keyword = st.nextToken();
		dest.append("[").append(attribute).append("=").append(keyword).append("]");
	    }
	}
    }


    /**
     * Takes a list of mp3 files as parameter
     * and generates a name-specifier for each file 
     */
    public static void main(String[] args) {


	MpegMetaDataExtractor mpegExtractor = new MpegMetaDataExtractor();

	for ( int i = 0; i < args.length; i++ ) {

	    String fullName = "";
	    if (args[i].endsWith(".mp3")) {
		fullName = args[i];
	    }
	    
	    else {
		fullName += args[i++];
		while(!args[i].endsWith(".mp3"))
		    fullName += " " + args[i++];
		fullName += " " + args[i];
	    }

	    NameSpecifier ns = mpegExtractor.extractDescrFromFile(fullName);
	    if ( ns != null )
		System.out.println(ns.toString());

	}

    }
	    
}
