package metadatagenerator;

import ins.namespace.*;
import java.io.*;
import java.util.*;


//-----------------------------------------------
/**
 * Generic interface
 * @author Magdalena Balazinska
 */
interface IParser {

    public StringBuffer parse(StreamTokenizer tokenizer) throws java.io.IOException;
    public String entryName();
	
}


//-----------------------------------------------
/**
 * Parser for bibtex entries
 * @author Magdalena Balazinska
 */
public class Parser implements IParser {

    Hashtable useless = new Hashtable();
    Hashtable substitution = new Hashtable();
    Hashtable fields = new Hashtable();

    public Parser(Hashtable u, Hashtable s) {
	useless = u;
	substitution = s;
	Author author = new Author(useless,substitution);
	Title  title  = new Title(useless,substitution);
	Year  year  = new Year(useless,substitution);
	Journal  journal  = new Journal(useless,substitution);
	Booktitle booktitle  = new Booktitle(useless,substitution);
	School school  = new School(useless,substitution);
	Institution inst  = new Institution(useless,substitution);
	Howpublished howpublished = new Howpublished(useless,substitution);

	fields.put("author",author);
	fields.put("title",title);
	fields.put("year",year);
	fields.put("journal",journal);
	fields.put("booktitle",booktitle);
	fields.put("school",school);
	fields.put("institution",inst);
	fields.put("howpublished",howpublished);
    }

    public String entryName() {
	return "Generic entry";
    }

    public String nameSpecPrefix() {
	return "[type=" + entryName();
    }

    public String nameSpecSuffix() {
	return "]";
    }


    public boolean end(StreamTokenizer tokenizer) throws IOException {

	char END = '}';
	String tokenString = tokenizer.toString();
	if ( tokenString.indexOf(END) != -1 ) {
		tokenizer.nextToken();
		if ( ( tokenizer.ttype == StreamTokenizer.TT_EOF )
		|| ( tokenizer.ttype == StreamTokenizer.TT_EOL ) )
			return true;
		tokenizer.pushBack();
	} 
	return false;

    }

    public StringBuffer parse(StreamTokenizer tokenizer) throws java.io.IOException {

	StringBuffer namespec = new StringBuffer();
	//System.out.println("\n\n >> Starting to parse " +entryName());
	while ( tokenizer.nextToken() != StreamTokenizer.TT_EOF ) {
	    switch (tokenizer.ttype) {
	    case StreamTokenizer.TT_WORD:
		String token = tokenizer.sval;
		IFieldParser f = (IFieldParser)fields.get(token);
		if ( f != null)
		    namespec.append(f.parse(tokenizer,nameSpecPrefix(),nameSpecSuffix()));
		break;
	    case StreamTokenizer.TT_NUMBER:
		break;
	    default:
		if (end(tokenizer))
		    return namespec;
	    }
	}
	return namespec;
    }
}


//-----------------------------------------------
/**
 * StringDef class parses string definitions and
 * adds them to the "substitution" hashtable
 */
class StringDef extends Parser {

    public StringDef(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() {
	return "string definition";
    }

    public StringBuffer parse(StreamTokenizer tokenizer) throws java.io.IOException {

	String key = null;
	String value = "";
	StringBuffer namespec = new StringBuffer();
	//System.out.println("\n\n >> Starting to parse " +entryName());
	while ( tokenizer.nextToken() != StreamTokenizer.TT_EOF ) {
	    switch (tokenizer.ttype) {
	    case StreamTokenizer.TT_WORD:
		String token = tokenizer.sval;
		if ( key == null )
		    key = token;
		else value += " " + token;
		break;
	    default:
		if ( end(tokenizer)) {
		    substitution.put(key,value);
		    return namespec;
		}
	    }
	}
	return namespec;
    }

}

//-----------------------------------------------
/**
 */
class Article extends Parser {

    public Article(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "article"; }

}

/**
 */
class InProceedings extends Parser {
    
    public InProceedings(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "inproceedings"; }

}


/**
 */
class MastersThesis extends Parser {

    public MastersThesis(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "mastersthesis"; }

}

/**
 */
class Misc extends Parser {

    public Misc(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "misc"; }
 
}

/**
 */
class PhdThesis extends Parser {

    public PhdThesis(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "phdthesis"; }

}

/**
 */
class TechReport extends Parser {

    public TechReport(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "techreport"; }
}


/**
 */
class Manual extends Parser {

    public Manual(Hashtable u, Hashtable s) {
	super(u,s);
    }

    public String entryName() { return "manual"; }
}



