package printer;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This is a component of the LPRClient
 */

public class LPRGUI
    implements ActionListener
{
    JFrame f;
    JPanel mainPane;
    LPRClient client;
    PrintQueue queue;

    public LPRGUI(LPRClient lprc, String printer, String location)
    {
	this.client = lprc;

	f = new JFrame("LPR Client: " + printer + " @ " + location);
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
		f.setVisible(false);
		f.setEnabled(false);
		f.dispose();

		client.cleanUp();
            }
        });

	queue = new PrintQueue();

	JButton update = new JButton("Update queue list");
	update.setMnemonic('u');
	update.setActionCommand("update");
	update.addActionListener(this);
	
	JButton submit = new JButton("Submit job to " + printer);
	submit.setMnemonic('p');
	submit.setActionCommand("submit");
	submit.addActionListener(this);

	JButton locSubmit = new JButton("Submit job to " + location);
	locSubmit.setMnemonic('l');
	locSubmit.setActionCommand("locSubmit");
	locSubmit.addActionListener(this);

	JButton remove = new JButton("Remove job");
	remove.setMnemonic('r');
	remove.setActionCommand("remove");
	remove.addActionListener(this);

	mainPane = new JPanel();
	Border b = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	mainPane.setLayout(gridbag);
        mainPane.setBorder(b);

	// For everything

	c.weighty = 1.0;

	// Queue

	c.weightx = 4.0;
	c.gridx = 0; c.gridy = 0;
	c.gridwidth = 4; c.gridheight = 1;
	c.fill = GridBagConstraints.BOTH;
	// c.anchor = GridBagConstraints.NORTH;
	gridbag.setConstraints(queue, c);
	mainPane.add(queue);

	// Buttons

	c.weightx = 1.0;
	c.gridwidth = 1; c.gridheight = 1;
	c.anchor = GridBagConstraints.SOUTH;
	c.fill = GridBagConstraints.HORIZONTAL;

	// Update button
	c.gridx = 0; c.gridy = 1;
	gridbag.setConstraints(update, c);
	mainPane.add(update);

	// Submit button
	c.gridx = 1; c.gridy = 1;
	gridbag.setConstraints(submit, c);
	mainPane.add(submit);

	// locSubmit button
	c.gridx = 2; c.gridy = 1;
	gridbag.setConstraints(locSubmit, c);
	mainPane.add(locSubmit);

	// Remove button
	c.gridx = 3; c.gridy = 1;
	gridbag.setConstraints(remove, c);
	mainPane.add(remove);

        f.setContentPane(mainPane);
        f.pack();
        f.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) 
    {
	if (e.getActionCommand().equals("update")) {
	    doUpdate();
	} else if (e.getActionCommand().equals("submit")) {
	    doSubmit(false);
	} else if (e.getActionCommand().equals("locSubmit")) {
	    doSubmit(true);
	} else if (e.getActionCommand().equals("remove")) {
	    doRemove();
	}
    }

    public void doSubmit(boolean toLocation)
    {
	JFileChooser chooser = new JFileChooser();
	int returnVal = chooser.showOpenDialog(mainPane);

	String status;
	if (returnVal == JFileChooser.APPROVE_OPTION) {
	    status = client.submitJob(chooser.getSelectedFile(),
				      toLocation);

	    System.out.println("back with status "+status);
	    JOptionPane.showMessageDialog(mainPane, status, "Status",
					  JOptionPane.PLAIN_MESSAGE);
	    doUpdate();
	}

    }

    public void doUpdate()
    {
	System.out.println("update pushed");
	queue.setQueue(client.checkQueue());
    }

    public void doRemove()
    {
	int job = queue.getSelectedJob();

	if (job == -1) {
	    JOptionPane.showMessageDialog(mainPane, 
					  "No job selected.",
					  "Status",
					  JOptionPane.PLAIN_MESSAGE);
	} else {
	    String status = client.removeJob(job);
	    JOptionPane.showMessageDialog(mainPane, status, "Status",
					  JOptionPane.PLAIN_MESSAGE);
	    doUpdate();
	}
    }
}
