package secureprinter;


import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;
import javax.swing.*;
import javax.swing.border.*;

/**
 * This is a component of the LPRClient
 */

public class PrintQueue extends JScrollPane {
    
    JList l;
    // JScrollPane sp;

    public PrintQueue()
    {
	super();

	setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

	l = new JList();
	// careful param order below!!
	l.setFont(new Font("Monospaced", Font.PLAIN, 12)); 
	getViewport().setView(l);
    }

    public void setQueue(String[] data)
    {
	l.setListData(data);
    }

    public int getSelectedJob()
    {
	String line = (String)l.getSelectedValue();
	if (line == null) {
	    return(-1);
	}

	StringTokenizer st = new StringTokenizer(line);

	int job = -1;
	while (st.hasMoreTokens()) {
	    String t = st.nextToken();
	    
	    try {
		job = Integer.parseInt(t);
		break;
	    } catch (NumberFormatException e) {
		continue;
	    }
	    
	}

	return(job);
    }
}
