package tests;

import ins.api.*;
import ins.namespace.*;
import ins.inr.*;
import java.io.*;
import java.util.*;
import metadatagenerator.*;
import cryptix.util.core.Hex;
import cryptix.provider.md.*;

/** 
 * This application automatically issues queries and measures
 * the success rate. <br>
 * 
 * This application takes a file full of queries as input
 * Each query appearing as one name-specifiers.
 * It issues them one by one, and measure the success rate.
 * @author Magdalena Balazinska
 */
public class Querier extends TwineApp {


    //-----------------------------------------------
    /**  
     * Constructors
     */
     public Querier(String dsrName) throws Exception {
	 super(dsrName);
	 time_out = 15000; // Long time_out for debugging only
	 this.enableSinglePeering();
     }

     public Querier(String resolverName, int port) throws Exception {
	 super(resolverName,port);
	 time_out = 15000; // Long time_out for debugging only
	 this.enableSinglePeering();
     }

    //-----------------------------------------------
    public void receivePacket(Packet p) {
	System.out.println("/ Received Packet:\n"+p.toString());
    }


    //-----------------------------------------------
    /**
     * This tokenizer considers white spaces part of tokens
     * allowing file names to contain spaces
     */
    public StreamTokenizer prepareSimpleTokenizer(FileReader fr) {
	
	StreamTokenizer tokenizer = new StreamTokenizer(fr); 
	tokenizer.resetSyntax();
	tokenizer.wordChars(0,Character.MAX_VALUE);
	tokenizer.whitespaceChars('\r','\r');
	tokenizer.whitespaceChars('\n','\n');
	tokenizer.eolIsSignificant(false); // It's just a separator
	return tokenizer;

    }

    //-----------------------------------------------
    /**  
     */
    public void query(String fileName) {

	boolean toall = true;
	int success = 0;
	int total = 0;
	
	try {

	    FileReader fr = new FileReader(fileName);
	    StreamTokenizer tokenizer = prepareSimpleTokenizer(fr);
	    while ( tokenizer.nextToken() != StreamTokenizer.TT_EOF ) {
		try {
		    Thread.sleep(1000);
		} catch (Exception e) {
		}

		String query = tokenizer.sval;
		//System.out.println("\nQuery is " + query);
		if (find(query,toall))
		    success++;
		total++;
	    }

	}  catch ( FileNotFoundException e ) {
	    System.err.println("Index file " + fileName + " not found");
	    return;
	} catch ( IOException e ) {
	    System.err.println("IOException reading file " + fileName);
	    return;
	}

	if ( total == 0 )
	    System.out.println("0.0\n");
	else 
	    System.out.println( (1.0*success/total) + "\n");
	
    }

    //-----------------------------------------------
    /**  
     */
    public boolean find(String query,boolean toall) {

	NameSpecifier n1 =new NameSpecifier(query);
	//System.out.println("/ searching all: "+n1.toString());
	EarlyBindRecord [] eb = getHostByiName(n1,toall);
	//System.out.println(" results length: "+eb.length);
	if ( eb.length > 0)
	    return true;
	else return false;

    } 

    
    //-----------------------------------------------
    /**  
     */
    public static void usage() {

	System.out.println("Usage:");
	System.out.println("java tests.Querier [-d dsrName] [-n INR:port] -f file");
	System.out.println("-d : allows to specify a non-local dsr");
	System.out.println("-n : allows to specify a TwineResolver directly");
	System.out.println("-f : is the name of the file containing the queries");
	System.exit(0);

    }

    //-----------------------------------------------
    /**  
     */
     public static Querier createFromOptions(String args[]) {

	NameSpecifier ns = null;
	String dsr = "localhost";
	String resolver = null;
	int port = -1;
	byte[] data = null;

	try {
	    for (int i = 0; i < args.length; i++) {
		String arg = args[i];
		String arg2 = null;
		if ( arg.equals("-d")) {
		    dsr = args[i+1];
		} else if ( arg.equals("-n")) {
		    arg2 = args[i+1];
		    int index = arg2.indexOf(':');
		    resolver = arg2.substring(0,index);
		    port = Integer.parseInt(arg2.substring(index+1,arg2.length()));
		    System.out.println("\n Connecting to: " + resolver 
				       + " on port " +port);
		} 
	    }
	} catch (Exception e) {
	    System.out.println(e.toString());
	    usage();
	}
	    
	// Create test application and start announcing name
	Querier q = null;
	try { 
	    if ( (resolver != null) && (port != -1))
		q = new Querier(resolver,port);
	    else 
		q = new Querier(dsr);
	} catch (Exception e) { 
	    System.out.println("Bad: "+e.toString());
	    System.exit(0);
	}
	return q;
    }



    //-----------------------------------------------
    /**  
     * 
     */
    public static void main(String args[]) {
	
	Querier q = createFromOptions(args);
	
	for (int i = 0; i < args.length; i++) {
	    if ( args[i].equals("-f") ) {
		i++;
		System.out.println("\nQuerying all " + args[i]);
		q.query(args[i]);
	    }	   
	}
	System.out.println("\nDone");
	System.exit(0);
    }


}
