package ins.dsr;

import java.util.Vector;
import java.util.Enumeration;

class NodeSet
{
    // VARIABLES

    Vector nodeSet;	// a vector of Node(s)
	// now nodeSet is a Vector, but later
	// may be changed to HashTable or any else faster

    // CONSTRUCTORS
    NodeSet()
    {
	nodeSet = new Vector(5);
    }

    NodeSet(Node n)
    {
	nodeSet = new Vector(5);
	nodeSet.addElement(n);
    }

    // METHODS
    Node get(Node n)
    {
	int i = nodeSet.indexOf(n);
	if (i > -1) 
	    return (Node)(nodeSet.elementAt(i));
	else
	    return null;
    }

    // adds
    void addUnconditionally(Node n)
    {
	nodeSet.addElement(n);
    }
   
    // adds, but protects against duplicates
    void put(Node n)
    {
	int index = nodeSet.indexOf(n);

	if (index  == -1)
	    nodeSet.addElement(n);
	else nodeSet.setElementAt(n, index);
    }

    boolean remove(Node n)
    {
	return nodeSet.removeElement(n);
    }

    int countNodes()
    {
	return nodeSet.size();
    }

    Node nodeNumber(int i)
    {
	return (Node)nodeSet.elementAt(i);
    }

    Enumeration getNodes()
    {
	return nodeSet.elements();
    }

    /**
     * Returns a String representation of the NodeSet.
     */
    public String toString()
    {
	StringBuffer strbuf = new StringBuffer("There are " +nodeSet.size()+" nodes.\n");

	for (int i=0; i<nodeSet.size(); i++)
	{
	    strbuf.append(((Node)(nodeSet.elementAt(i))).toString());
	    strbuf.append("\n");
	}

	return (strbuf.toString());
    }

}
