package ins.dsr;

import java.util.Vector;
import java.util.Enumeration;

/**
 * This is a class that represents a list of strings and can take it
 * to an from an efficient wireform format. This is mostly for making
 * writing DSRRequest/DSRResponse easier.  
 */

public class StringSet {

    private Vector rep;

    // constructors
    public StringSet() {
	rep = new Vector(4);
    }

    public StringSet(Vector v) {
	rep = new Vector(v.size());
	Enumeration e = v.elements();

	while (e.hasMoreElements()) {
	    Object o = e.nextElement();
	    if (o instanceof String) rep.addElement(o);
	}
    }

    public StringSet(String [] s) 
    {
	rep = new Vector(s.length);

	for (int i=0; i<s.length; i++) {
	    if (s[i]!=null) rep.addElement(s[i]);
	}
    }

    public StringSet(String s) {
	rep = new Vector(4);
	if (s!=null) rep.addElement(s);
    }

    // Accessor methods
    public void add(String s) 
    {
	if (s!=null) rep.addElement(s);
    }

    public boolean remove(String s) 
    {
	return rep.removeElement(s);
    }

    public Enumeration elements() 
    {
	return rep.elements();
    }

    public String [] produceArray() 
    {
	String [] str = new String[rep.size()];
	rep.copyInto(str);
	return str;
    }

    /* Exposes the underlying rep- be careful */
    public Vector getVector() 
    {
	return rep;
    }

    public static StringSet readWireform(byte [] data) 
    {
	return readWireform(data, 0, data.length);
    }

    public static StringSet readWireform(byte [] data, int offset, int length)
    {
	if (offset+length>data.length) return null;
	
	StringSet ss = new StringSet();

	int pos = 0;
	while (pos<length) {
	    int len = Conversion.extract16toIntLow16(data, pos+offset);
	    if (len==0) break;
	    if (len>length-pos-2) break;
	    ss.add(new String(data, offset+pos+2, len));
	    pos += (2+len);
	}

	return ss;
    }


    public byte [] toBytes() 
    {
	Object table [] = new Object[rep.size()];

	int totsize = 2;

	for (int i=0; i<table.length; i++) {
	    byte [] b = ((String)rep.elementAt(i)).getBytes();
	    table[i] = b;
	    totsize += (b.length + 2);
	}

	byte [] data = new byte[totsize];
	int pos = 0;

	for (int i=0; i<table.length; i++) {
	    byte [] b = (byte[])(table[i]);
	    Conversion.insertIntLow16(data, pos, b.length);
				      
	    System.arraycopy(b, 0, data, pos+2, b.length);
	    pos += (b.length+2);
	}

	Conversion.insertIntLow16(data, pos, 0);
	return data;
    }

    public String toString() 
    {
	return rep.toString();
    }

    /* test case */
/*    public static void main(String args[]) {
	StringSet ss = new StringSet();
	ss.add("hi");
	ss.add("there");
	ss.add("how are");
	ss.add("you");
	System.out.println("here is "+ss.toString());
	byte [] b = ss.toBytes();
	System.out.println("compressed to "+b.length+" bytes");
	StringSet ss2 = StringSet.readWireform(b);
	System.out.println("after "+ss2.toString());
	} */

}


