package ins.inr;

import java.net.InetAddress;

public class Conversion
{
    // UTILITY METHODS 
    
    public static void insertIntLow16(byte[] packet, int startByte, int value)
    {
	packet[startByte]   = (byte)( value       & 0xFF);
	packet[startByte+1] = (byte)((value >> 8) & 0xFF);
    }

    public static void insertInt(byte[] packet, int startByte, int value)
    {
	packet[startByte]   = (byte)( value        & 0xFF);
	packet[startByte+1] = (byte)((value >>  8) & 0xFF);
	packet[startByte+2] = (byte)((value >> 16) & 0xFF);
	packet[startByte+3] = (byte)((value >> 24) & 0xFF);
    }

    public static void insertLong(byte[] packet, int startByte, long value)
    {
	packet[startByte]   = (byte)( value        & 0xFF);
	packet[startByte+1] = (byte)((value >>  8) & 0xFF);
	packet[startByte+2] = (byte)((value >> 16) & 0xFF);
	packet[startByte+3] = (byte)((value >> 24) & 0xFF);
	packet[startByte+4] = (byte)((value >> 32) & 0xFF);
	packet[startByte+5] = (byte)((value >> 40) & 0xFF);
	packet[startByte+6] = (byte)((value >> 48) & 0xFF);
	packet[startByte+7] = (byte)((value >> 56) & 0xFF);
    }

    public static int extract16toIntLow16(byte[] packet, int startByte)
    {
	return (   ((int)packet[startByte] & 0xFF)
	       	| (((int)packet[startByte+1] << 8) & 0xFF00));
    }

    public static int extract32toInt(byte[] packet, int startByte)
    {
	return   ( ((int)packet[startByte]          & 0xFF)
	 	| (((int)packet[startByte+1] <<  8) & 0xFF00)
	 	| (((int)packet[startByte+2] << 16) & 0xFF0000)
	 	| (((int)packet[startByte+3] << 24) & 0xFF000000));
    }

    public static long extract64toLong(byte[] packet, int startByte)
    {
	return   ( ((long)packet[startByte]          & 0xFFl)
	 	| (((long)packet[startByte+1] <<  8) & 0xFF00l)
	 	| (((long)packet[startByte+2] << 16) & 0xFF0000l)
	 	| (((long)packet[startByte+3] << 24) & 0xFF000000l)
	 	| (((long)packet[startByte+4] << 32) & 0xFF00000000l)
	 	| (((long)packet[startByte+5] << 40) & 0xFF0000000000l)
	 	| (((long)packet[startByte+6] << 48) & 0xFF000000000000l)
	 	| (((long)packet[startByte+7] << 56) & 0xFF00000000000000l) );
    }

    public static boolean getBooleanFromByte(byte data, int bit)
    {
	byte mask = (byte)(1 << bit);
	return((data & mask) == mask);
    }

    public static byte setByteFromBoolean(byte data, int bit, boolean b)
    {
	byte mask = (byte)(1 << bit);

	if (b) {
	    return (byte)(data | mask);
	} else {
	    return (byte)(data & ~mask);
	}
    }

    public static boolean byteCompare(byte[] data1, byte[] data2, int length)
    {
	if ((data1.length < length) || (data2.length < length))
	    return false;

	for (int i=0; i<length; i++)
	    if (data1[i] != data2[i]) return false;

	return true;
    }

    public static InetAddress extractInetAddress(byte[] data, int offset)
    {
	InetAddress ia = null;
/*
	try {
	    ia = InetAddress.getByName(Integer.toString(data[offset])+"."+
				       Integer.toString(data[offset+1])+"."+
				       Integer.toString(data[offset+2])+"."+
				       Integer.toString(data[offset+3]));
	} catch (Exception e) { ia = null; }
	return ia;
*/

	// Changed by: Jorge Rafael Nogueras (9/25/00)
	// Added "& 0xFF" because byte values are always signed to prevent
	// negative numbers to appear in IP address
	try {
	    ia = InetAddress.getByName(Integer.toString(data[offset] & 0xFF)+"."+
				       Integer.toString(data[offset+1] & 0xFF)+"."+
				       Integer.toString(data[offset+2] & 0xFF)+"."+
				       Integer.toString(data[offset+3] & 0xFF));
	} catch (Exception e) { ia = null; }
	return ia;

    }

}



