package ins.inr;

public interface IHandler
{

    /** 
     *  A callback function: will be called during initialization
     *  Provide an access to the VSNameTree and Forwarder objects
     *  @param r the Resolver object
     *  NOTE: The CONSTRUCTOR of a class that implements this interface
     *  should NOT call any method of Resolver (or access Resolver's variables)
     *  nor should any thread that you create be started inside constructor!
     *  Instead, do those within this init() method. 
     */
    public void init(Resolver r);

    /** 
     *  A callback function: will be called every time a new
     *  INS packet for this handler arrives by UDP
     *  @param msg
     */
    public void INSreceive(Message msg);

    /** 
     *  A callback function: will be called every time a new
     *  INS packet for this handler arrives by TCP.
     *  (Interface implementation of IHandler)
     *  @param p the INS packet
     *  @param from the neighbor sending the packet p     
     */
    public void INSreceiveByTCP(Packet p, Node from);


}