package ins.inr;

import java.io.*;

class LoggedPrintStream
    extends PrintStream
{
    // VARIABLES
    String logfile;
    PrintWriter pw;
    PrintStream sysout;
    boolean isLog;
        
    // CONSTRUCTORS    
    LoggedPrintStream(OutputStream out)
    {
    	super(out);
    	sysout = (PrintStream)out;
    	isLog = true;
	try{
	    logfile = "Resolver.log";
	    pw = new PrintWriter(new FileWriter(logfile), true);
	} catch (IOException e) {
	    isLog = false;
	}
    }
    
    LoggedPrintStream(OutputStream out, boolean autoFlush)
    {
    	super(out, autoFlush);
    	sysout = (PrintStream)out;
    	isLog = true;
	try{
	    logfile = "Resolver.log";
	    pw = new PrintWriter(new FileWriter(logfile), true);
	} catch (IOException e) {
	    isLog = false;
	}
    }
    
    // METHODS
    public void flush()
    {
    	sysout.flush();
    	if (isLog) pw.flush();
    }

    public void close()
    {
    	sysout.close();
    	if (isLog) pw.close();
    }

    public void write(int b)
    {
    	sysout.write(b);
    	if (isLog) pw.write(b);
    }
    
    
    public void write(byte[] buf,
                  int off,
                  int len)
    {
    	sysout.write(buf, off, len);
    	if (isLog)
    	{
    	    for (int i=0; i<len; i++)
		pw.print((char)buf[off+i]);
	}
    }

    public void print(boolean b)
    {
    	sysout.print(b);
    	if (isLog) pw.print(b);
    }

    public void print(char c)
    {
    	sysout.print(c);
    	if (isLog) pw.print(c);
    }
    
    public void print(int i)
    {
    	sysout.print(i);
    	if (isLog) pw.print(i);
    }

    public void print(long l)
    {
    	sysout.print(l);
    	if (isLog) pw.print(l);
    }
        
    public void print(float f)
    {
    	sysout.print(f);
    	if (isLog) pw.print(f);
    }

    public void print(double d)
    {
    	sysout.print(d);
    	if (isLog) pw.print(d);
    }

    public void print(char[] s)
    {
    	sysout.print(s);
    	if (isLog) pw.print(s);
    }

    public void print(String s)
    {
    	sysout.print(s);
    	if (isLog) pw.print(s);
    }

    public void print(Object obj)
    {
    	sysout.print(obj);
    	if (isLog) pw.print(obj);
    }

    public void println()
    {
    	sysout.println();
    	if (isLog) pw.println();
    }    
    
    public void println(boolean x)
    {
    	sysout.println();
    	if (isLog) pw.println();
    }  

    public void println(char x)
    {
    	sysout.println();
    	if (isLog) pw.println();
    }  

    public void println(int x)
    {
    	sysout.println();
    	if (isLog) pw.println();
    }  

    public void println(long x)
    {
    	sysout.println();
    	if (isLog) pw.println();
    }  

    public void println(double x)
    {
    	sysout.println(x);
    	if (isLog) pw.println(x);
    }  

    public void println(char[] x)
    {
    	sysout.println(x);
    	if (isLog) pw.println(x);
    }  

    public void println(String x)
    {
    	sysout.println(x);
    	if (isLog) pw.println(x);
    }  

    public void println(Object x)
    {
    	sysout.println(x);
    	if (isLog) pw.println(x);
    }  
    
}