package ins.inr;

import java.net.*;

/**
 * Encapsulate three information into a class:
 *   INS packet, sender/receiver's IP address and port number
 */
public class Message
{
    //  public byte[] data;  // the message itself
    Packet packet;
    InetAddress ia;
    int port;

    /**
     * Create a new Message.
     */
    public Message(Packet p, InetAddress i, int n)
    {
	packet = p;
	ia = i;
	port = n;
    }
    
    Packet getPacket() { return packet; }
    byte [] getPacketBytes() { return packet.toBytes(); }

    public String toString()
    {
	String output = "Message contains a packet: \n" + packet.toString() +
	    "\n  to/from: " + ia.toString() + ":" + port + "\n";

	return(output);
    }	

}
    
