package ins.inr;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

class MobilitySocket 
{
    private DatagramSocket socket;
    public static int BUFFER_FACTOR = 4;
    
    public MobilitySocket() 
	throws SocketException
    {
	socket = new DatagramSocket();
	increaseBufferSizes();
    }

    public MobilitySocket(int port) 
	throws SocketException
    {
	socket = new DatagramSocket(port);
	increaseBufferSizes();
    }

    public MobilitySocket(int port,
			  InetAddress laddr) throws SocketException
    {
	socket = new DatagramSocket(port, laddr);
	increaseBufferSizes();
    }

    /**
     * @author Magdalena Balazinska
     */
    public void increaseBufferSizes() throws SocketException 
    {

	socket.setReceiveBufferSize(BUFFER_FACTOR*socket.getReceiveBufferSize());
	socket.setSendBufferSize(BUFFER_FACTOR*socket.getSendBufferSize());
	System.out.println("\nBuffer sizes are: ");
	System.out.println(" => input  " + socket.getReceiveBufferSize());
	System.out.println(" => output " + socket.getSendBufferSize());

    }

    public synchronized InetAddress getLocalAddress()
    {
	return socket.getLocalAddress();
    }
    
    public synchronized void close()
    {
	socket.close();
    }

    public synchronized int getLocalPort()
    {
	return socket.getLocalPort();
    }

    
    public synchronized void send(DatagramPacket p)
	throws IOException
    {
	socket.send(p);
    }

    public void receive(DatagramPacket p)
	throws IOException
    {
	socket.receive(p);
	System.out.println("\nPacket size is: "+ p.getLength());
    }
    
    public synchronized void rebind (InetAddress ia)
	throws SocketException
    {
	int port = socket.getLocalPort();
	socket.close();
	System.out.println("Old socket closed");
	System.out.print("Creating new socket...");
	socket = new DatagramSocket(port, ia);
	System.out.println("done!");
    }

}
