package ins.inr;

import java.net.InetAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import java.util.Enumeration;

public class Node
{
    // VARIABLES

    // these refer to the state of the link for the OverlayManager
    // (whether it is an active/dormant/etc. neighbor or not)
    public final static int INACTIVE = 0;
    public final static int ACTIVE = 1;
    public final static int DORMANT = 2;
    public final static int PROGRESS = 3;
    public final static int ADDING = 4;

    InetAddress ia;
    int UDPport;
    int TCPport;
    Vector vspaces;
    int rtt;

    /** expireTime ONLY refers to vspaces that we do not host
     * (e.g. we may host a & b, and a node might have entries
     *  for a, b, & c. The expireTime only will expire c.
     */
    long expireTime;

    // the TCP processing thread associated with this neighbor
    // only used if it is a neighbor
    TCPForwardThread thread;
    DataInputStream in;
    DataOutputStream out;

    boolean sendAllKnown;

    // data for overlay manager
    int state;

    //     ExclusiveAccessBy = "(m,n):Cmn"
    int expMetric;
    long expInit;
    long expSource;
    String expVSpace;

    // outdated
    // boolean rttLocked;

    //     Accessed by = a set of "(m,n):Cmn"
    Vector accessByI;   
    Vector accessByS;
    Vector accessByC;


    Node (InetAddress i, int udp, int tcp)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = new Vector(2);
	rtt = Integer.MAX_VALUE;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = Long.MAX_VALUE;
	
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }

    Node (InetAddress i, int udp, int tcp, long ttl)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = new Vector(2);
	rtt = Integer.MAX_VALUE;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = ((ttl == Long.MAX_VALUE)? ttl : 
		      (ttl+System.currentTimeMillis()));	
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }


    Node (InetAddress i, int udp, int tcp, String vs)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = new Vector(2);
	vspaces.addElement(vs);
	rtt = Integer.MAX_VALUE;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = Long.MAX_VALUE;
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }

    Node (InetAddress i, int udp, int tcp, String vs, long ttl)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = new Vector(2);
	vspaces.addElement(vs);
	rtt = Integer.MAX_VALUE;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = ((ttl == Long.MAX_VALUE)? ttl : 
		      (ttl+System.currentTimeMillis()));	
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }

    Node (InetAddress i, int udp, int tcp, Vector vs)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = vs;
	rtt = Integer.MAX_VALUE;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = Long.MAX_VALUE;
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }

    Node (InetAddress i, int udp, int tcp, Vector vs, int t)
    {
	ia = i;
	UDPport = udp;
	TCPport = tcp;
	vspaces = vs;
	rtt = t;
	thread = null;
	in = null;
	out = null;
        sendAllKnown = false;
	state = INACTIVE;
	expMetric = 0;
	expInit = 0;
	expSource = 0;
	expVSpace = null;
	//rttLocked = false;
	expireTime = Long.MAX_VALUE;
	accessByI = new Vector();
	accessByS = new Vector();
	accessByC = new Vector();		
    }

    void addVspace(String vs)
    {
	if (vspaces.indexOf(vs) == -1)
	    vspaces.addElement(vs);
    }

    void removeVspace(String vs)
    {
	vspaces.removeElement(vs);
    }

    Enumeration getVspaces()
    {
	return vspaces.elements();
    }

    int countVspaces()
    {
	return vspaces.size();
    }


    /** 
     * Gets the time to live, in ms. 
     * Long.MAX_VALUE means that it never expires 
     */
    public long getTTL() 
    { 
	if (expireTime==Long.MAX_VALUE) 
	    return expireTime;
	else
	    return (expireTime-System.currentTimeMillis());
    }
    
    /** 
     * Sets the ttl in ms, with Integer.MAX_VALUE meaning that
     *      it never expires 
     */
    public void setTTL(long ttl) 
    {
	if (ttl==Long.MAX_VALUE) 
	    expireTime=ttl;
	else 
	    expireTime = System.currentTimeMillis()+ttl;
    }

    public boolean isExpired() 
    {
	return (System.currentTimeMillis()>expireTime);
    }

    public boolean isExpired(long curTime) 
    {
	return (curTime>expireTime);
    }

    public void updateTTL(long ttl) 
    {
	long expireTime = (ttl==Long.MAX_VALUE? Long.MAX_VALUE :
			   System.currentTimeMillis()+ttl);

	if (expireTime > this.expireTime)
	    this.expireTime = expireTime;
    }

    /**
     * If the TTL < 10 minutes, raises it to that point.
     */
    public void touchTTL()
    {
	updateTTL(600000);
    }

    /**
     * Returns true if the IP address and port number are
     * equal (note: no comparison of vspaces performed).
     */
    public boolean equals(Object obj)
    {
	if (obj instanceof Node)
	{
	    Node n = (Node)obj;

	    // Note: port# 0 matches everything
	    if (ia.equals(n.ia) &&
		((UDPport==n.UDPport) || (UDPport==0) || (n.UDPport==0)) &&
		((TCPport == n.TCPport) || (TCPport==0) || (n.TCPport==0)))
		return true;
	    else
		return false;
	}
	else return false;
    }

    public int hashCode()
    {
	return ia.hashCode();
    }

    public long getINRuid()
    {
	long INRuid = (long)(Conversion.extract32toInt(ia.getAddress(), 0));
	INRuid = (INRuid << 16) | ((long)UDPport & 0xFFFFl);
	return INRuid;
    }


    static String timeLeft(long time)
    {
	int days = (int)(time/86400000);
	time = time %86400000;
	int hours = (int)(time/3600000);
	time = time % 3600000;
	int min = (int)(time/60000);
	int t1 = (int)(time % 60000);
	int sec = t1/1000;
	
	return (Integer.toString(days) + "d" + Integer.toString(hours) + ":" +
		Integer.toString(min) + ":" + Integer.toString(sec) +
		"." + Integer.toString(t1%1000) + "s");
    }

    /**
     * Returns a String representation of the Node.
     */
    public String toString()
    {
	return (ia.toString() + ":" + UDPport + ":" + TCPport +
		" <"+vspaces.toString()+">" +
		((thread==null)? " NO" : " YES") +
		((in==null)? " NO" : " YES") +
		((out==null)? " NO" : " YES") +
		((sendAllKnown)? " YES" : " NO") +
		" rtt = " + rtt +
		" ttl = " + 
		(expireTime==Long.MAX_VALUE?"INFINITE":
		 timeLeft(expireTime-System.currentTimeMillis())));
    }
}
