package ins.inr;

import java.util.Vector;
import java.util.Enumeration;

/**
 * A NodeSet represents a set of nodes, currently implemented
 * using a Vector. 
 *
 * (If this code becomes a performance bottleneck, it may be worthwhile 
 *  to have two versions of this code -- a Vector and a Hashtable --
 *  and to make the NodeSet an interface. There are some cases in which
 *  lookup speed is more important, and there are some cases in which
 *  being lightweight is more important. anyway.)
 */

class NodeSet
{
    // VARIABLES

    Vector nodeSet;	// a vector of Node(s)
	// now nodeSet is a Vector, but later
	// may be changed to HashTable or any else faster

    // CONSTRUCTORS
    NodeSet()
    {
	nodeSet = new Vector(5);
    }

    NodeSet(Node n)
    {
	nodeSet = new Vector(5);
	nodeSet.addElement(n);
    }

    NodeSet(NodeSet ns)
    {
	this.nodeSet = new Vector(ns.nodeSet.size());

	for (Enumeration e= ns.nodeSet.elements(); e.hasMoreElements(); )
	{
	    this.nodeSet.addElement(e.nextElement());
	}
    }

    // METHODS
    Node get(Node n)
    {
	int i = nodeSet.indexOf(n);
	if (i > -1) 
	    return (Node)(nodeSet.elementAt(i));
	else
	    return null;
    }

    void put(Node n)
    {
	nodeSet.addElement(n);
    }

    boolean remove(Node n)
    {
	return nodeSet.removeElement(n);
    }

    int countNodes()
    {
	return nodeSet.size();
    }

    Node nodeNumber(int i)
    {
	return (Node)nodeSet.elementAt(i);
    }


    Enumeration getNodes()
    {
	return nodeSet.elements();
    }


    Node pickNode()
    {
	long time = System.currentTimeMillis();
	for (int i = 0; i<nodeSet.size(); i++)
	{
	    Node n = (Node)nodeSet.elementAt(i);
	    if (!n.isExpired(time))
		return n;
	}
	return null;
    }

    /**
     * Returns a String representation of the NodeSet.
     */
    public String toString()
    {
	StringBuffer strbuf = new StringBuffer("There are " +nodeSet.size()+" nodes.\n");

	for (int i=0; i<nodeSet.size(); i++)
	{
	    strbuf.append(((Node)(nodeSet.elementAt(i))).toString());
	    strbuf.append("\n");
	}

	return (strbuf.toString());
    }

}
