package ins.inr;

import java.util.Date;

public class RouteEntry
{
    // VARIABLES;
    protected long INRuid;	// read only, to make sure RouteEntry 
				// consistent with its key in HashTable
    public Node nextHop;
    public int metricHop;
    public int metricRTT;
    public Date expireTime;        // when the route expires

    // VARIABLES
    public RouteEntry(long uid, Node n, int hop, int RTT, long lifetime)
    {
	INRuid = uid;
	nextHop = n;
	metricHop = hop;
	metricRTT = RTT;

	// Set the expire time
	if (lifetime==-1)
	    expireTime = null;
	else
	{
	    Date now = new Date();
	    expireTime = new Date(now.getTime() + lifetime);
	}
    }

    RouteEntry(RouteUpdate ru, int addHop, int addRTT, Node n, long lifetime)
    {
	INRuid = ru.INRuid;
	nextHop = n;
	metricHop = ru.metricHop + addHop;
	metricRTT = ru.metricRTT + addRTT;

	// Set the expire time
	if (lifetime==-1)
	    expireTime = null;
	else
	{
	    Date now = new Date();
	    expireTime = new Date(now.getTime() + lifetime);
	}
    }

    void update(Node n, int hop, int RTT, long lifetime)
    {
	nextHop = n;
	metricHop = hop;
	metricRTT = RTT;

	// Set the expire time
	if (lifetime==-1)
	    expireTime = null;
	else
	{
	    Date now = new Date();
	    expireTime = new Date(now.getTime() + lifetime);
	}
    }

    long getINRuid()
    {
	return INRuid;
    }

    /** 
     * Returns true if the RouteEntry is expired.
     */
    public boolean testExpiration()
    {
	return testExpiration(new Date());
    }

    /** 
     * Returns true if the RouteEntry is expired.
     */
    public boolean testExpiration(Date now)
    {
	if (expireTime==null)	// never expire
	    return false;

	if (now.after(expireTime)) {
	    return(true);
	} else {
	    return(false);
	}
	
    }


    /**
     * Returns a String representation of the RouteEntry.
     */
    public String toString()
    {
	return (" INR uid: " + INRuid + " next hop: " +
	    ((nextHop==null)?"null":nextHop.toString()) +
	    " metric hop: " + metricHop +
	    " metric RTT: " + metricRTT +
	    " expires in " +
	 ((expireTime==null)?"never":durationToString(
	    expireTime.getTime() - (new Date()).getTime())));
    }


    private String durationToString(long d)
    {
	long years, days, hours, minutes, seconds;

	years = d / 31536000000l;
	d = d % 31536000000l;

	days = d / 86400000l;
	d = d % 86400000l;

	hours = d / 3600000l;
	d = d % 3600000l;

	minutes = d / 60000l;
	d = d % 60000l;

	seconds = d / 1000l;

	String output = "";

	if (years == 1l) {
	    output = output + "1 year ";
	} else if (years > 1l) {
	    output = output + years + " years ";
	}

	if (days == 1l) {
	    output = output + "1 day ";
	} else if (days > 1l) {
	    output = output + days + " days ";
	}

	if (hours == 1l) {
	    output = output + "1 hour ";
	} else if (hours > 1l) {
	    output = output + hours + " hours ";
	}

	if (minutes == 1l) {
	    output = output + "1 minute ";
	} else if (minutes > 1l) {
	    output = output + minutes + " minutes ";
	}

	if (seconds == 1l) {
	    output = output + "1 second ";
	} else if (seconds > 1l) {
	    output = output + seconds + " seconds ";
	}

	return(output);
    }

}
