package ins.inr;

import java.util.Hashtable;
import java.util.Enumeration;

/**
 * This table maps INR uids to RouteEntries for a specific Vspace.
 */

class RouteTable
{
    Hashtable table;

    RouteTable()
    {
	table = new Hashtable(47); // size=47 some prime number
			// size of table = number of INRs in the system
    }

    synchronized RouteEntry lookup(long uid)
    {
	RouteKey k = new RouteKey(uid);
	RouteEntry re = (RouteEntry)(table.get(k));
	if ((re!=null) && (re.testExpiration()))
	{
	    table.remove(k);
	    return null;
	}
	else
	    return re;
    }

    void add(long uid, Node nextHop, int hop, int rtt, long lifetime)
    {
	RouteEntry re = new RouteEntry(uid, nextHop, hop, rtt, lifetime);
	add(uid, re);
    }

    synchronized void add(long uid, RouteEntry re)
    {
	RouteKey k = new RouteKey(uid);
	table.put(k, re);
    }

    synchronized void remove(long uid)
    {
	RouteKey k = new RouteKey(uid);
	RouteEntry re = (RouteEntry)table.remove(k);
	if (re == null)
	    System.out.println("***WARNING:  Removing " + uid + " from RouteTable fails");
	//else
	//    System.out.println("RouteTable removed: " + re.toString());
    }

    synchronized Enumeration getRouteEntries()
    {
    	// Remove expired entries
 	for (Enumeration e=table.elements(); e.hasMoreElements(); )
	{
	    RouteEntry re = (RouteEntry)(e.nextElement());
	    if (re.testExpiration())
	    	table.remove(new RouteKey(re.INRuid));
	}
	    	
	return table.elements();
    }

    /**
     * Returns a String representation of the VSRouteTable.
     */
    public String toString()
    {
	return table.toString();
    }

    class RouteKey
    {
	private long key;

	RouteKey(long k) { key=k; }

	public int hashCode() {
	    return (int)(key & 0x00FFFF);
	}

	public boolean equals(Object obj) {
	    if (obj instanceof RouteKey)
	    {
		RouteKey rk = (RouteKey)obj;
		return (rk.key == key);
	    }
	    else
		return false;
	}
    }
}

