package ins.inr;

class RouteUpdate
{
    // VARIABLES
    long INRuid;
    int metricHop;
    int metricRTT;
    
    RouteUpdate(RouteEntry re)
    {
	if (re==null)
	{
	    System.out.println("ASSERT: Can't construct RouteUpdate based on"+
		" null RouteEntry!");
	}
	else
	{
	    INRuid = re.getINRuid();
	    metricHop = re.metricHop;
	    metricRTT = re.metricRTT;
	}
    }

    RouteUpdate(long uid, int hop, int rtt)
    {
	INRuid = uid;
	metricHop = hop;
	metricRTT = rtt;
    }

    RouteUpdate(byte[] bytes)
    {
	fillInFromBytes(bytes, bytes.length);
    }

    RouteUpdate(byte[] bytes, int length)
    {
	fillInFromBytes(bytes, length);
    }

    protected void fillInFromBytes(byte[] bytes, int length)
    {
	INRuid = Conversion.extract64toLong(bytes, 0);
	metricHop = (int)(bytes[8] & 0xFF);
	metricRTT = Conversion.extract32toInt(bytes, 9);
    }

    byte[] toBytes()
    {
	byte[] bytes = new byte[13];

	Conversion.insertLong(bytes, 0, INRuid);
	bytes[8] = (byte)(metricHop & 0xFF);
	Conversion.insertInt(bytes, 9, metricRTT);

	return bytes;
    }

    /**
     * Returns a String representation of the RouteUpdate.
     */
    public String toString()
    {
	return ("RouteUpdate for INRuid " + INRuid +" with hop "+metricHop+
	   " and RTT "+ metricRTT);
    }

}