package ins.inr;

import java.util.Enumeration;

class RouteUpdateThread
    extends Thread
{
    // VARIABLES
    protected RouteManager routeMn;
    protected VSNeighbors neighbors;
    boolean updatingRoutes;

    protected RouteEntry myuidRE;


    // CONSTRUCTORS
    RouteUpdateThread(RouteManager r)
    {
	routeMn = r;
	neighbors = r.neighbors;
	updatingRoutes = true;
	myuidRE = r.myuidRE;

	if (myuidRE == null)	// fatal error, should not happen
	{
	    System.out.println("RouteUpdateThread: Fatal Error: routeTable is"+
		" not correctly initialzed yet inside RouteUpdateThread"+
		" constructor.");
	    System.exit(-1);
	}	
    }

    // METHODS
    public void run()
    {
	while (updatingRoutes)
	{
	    try {Thread.sleep(RouteManager.ROUTE_UPDATE_INTERVAL);}
	    catch (InterruptedException e) {e.printStackTrace();}

	    for (Enumeration e = neighbors.getVspaces(); e.hasMoreElements();)
	    { 
		String vspace = (String)e.nextElement();
		routeMn.sendRouteUpdate(vspace, myuidRE, myuidRE.nextHop /*==null*/);
	    }
	}
    }
}
