package ins.inr;

class SendWithRetransmit
    implements Runnable
{
    // VARIABLES
    Communicator comm;
    Packet packet;
    Node to;
    MutableBoolean isWaiting;
    Object waitOn;
    long timer;
    boolean isTCP;

    // CONSTRUCTORS
    SendWithRetransmit(Communicator comm, Packet packet, Node to,
	MutableBoolean isWaiting, Object waitOn, long timer, 
	boolean isTCP)
    {
	this.comm = comm;
	this.packet = packet;
	this.to = to;
	this.isWaiting = isWaiting;
	this.waitOn = waitOn;
	this.timer = timer;
	this.isTCP = isTCP;
    }

    // METHODS
    public void run()
    {
	// Message is only for UDP send
	Message msg = null;

	while (isWaiting.value)
	{
	    // System.out.println("SendWithRetransmit: isWaiting = " +
	    //	isWaiting.toString());
	    	
	    if (isTCP) comm.sendByTCP(packet, to);
	    else 
	    {
		if (msg == null)
		    msg = new Message(packet, to.ia, to.UDPport);
		comm.sendMessage(msg);
	    }

	    if (Resolver.DEBUG >=3)
		System.out.println("SendWithRetransmit: re/sent message ...");
	    
	    // wait for reply (only used when re-transmission implemented)
	    try {
	    synchronized (waitOn) {
	    	// System.out.println("SendWithRetransmit: wait on " +
		//    waitOn.toString());
		waitOn.wait(timer);
	    }
	    } catch (InterruptedException e) {
		e.printStackTrace();
	    }
	    
	    //System.out.println("SendWithRetransmit: isWaiting = " + 
	    //    isWaiting.value);
	}
	
	if (Resolver.DEBUG >=3)
	    System.out.println("SendWithRetransmit: exiting...");
    }
}
