package ins.inr;
import java.net.*;
import java.util.*;

//-----------------------------------------------------
/**
 *
 * This class implements a very simple thread pool
 * that performs generic "Tasks"
 * @author Magdalena Balazinska
 */
public class SimpleThreadPool implements Runnable {

    public Thread[] threadpool;    
    public LinkedList tasks;
    public int nbThreads;
    protected TwineLogger log;

    public SimpleThreadPool(TwineLogger l, int nbT) {

	log = l;
	nbThreads = nbT;
	threadpool = new Thread[nbThreads];
	tasks = new LinkedList();
	for ( int i = 0; i < nbThreads; i++) {
	    threadpool[i] = new Thread(this);
	    threadpool[i].start();
	}
    }  

    /** 
     * Consume
     */
    public synchronized Task getOneTask() {
	
	Task t = null;
	try { 
	    while ( tasks.isEmpty() ) {
		try {
		    wait();
		} catch (InterruptedException e) {
		}
	    }
	    t = (Task)tasks.removeFirst();
	} catch (NoSuchElementException e) {
	} 	
	return t; 
	
    }

    /**
     * Produce
     */
    public synchronized void addOneTask(Task t) {
	tasks.addLast(t);
	notify();

    }

    public void run() {

	Task t = null;
	log.printStatus("Starting one key router thread\n",
			TwineLogger.IMPORTANT_MSG);
	while (true) {	    
	    t = getOneTask();
	    t.run();
	}
    }

}
