package ins.inr;

import java.net.*;
import java.io.*;

class TCPForwardThread
    extends Thread
{
    Socket socket;
    DataInputStream in;
    InetAddress neighborAddr;
    int neighborPort;
    boolean isInitiator;
    Node node;

    int retries;

    Communicator comm;
    Forwarder forwarder;
    OverlayManager overlayMn;

    boolean isReceiving;

    TCPForwardThread(Socket s, DataInputStream i, Communicator c, 
	Forwarder f, OverlayManager o, Node n, boolean b)
    {
	socket = s;
	neighborAddr = s.getInetAddress();
	neighborPort = s.getPort();
	in = i;
	comm = c;
	forwarder = f;
	node = n;
	isInitiator = b;
	overlayMn = o;
	
	//retries =0;

	isReceiving = true;
    }

    public void run() 
    {
	int packetLen;
	byte [] receiveBuffer = new byte[Packet.MAX_PACKET_SIZE]; // arbitrary choice
	Packet p;

	while (isReceiving)
	{
	    try 
	    {
	        // If problem on connection
		if (in == null)
		{
		    if (socket != null) socket.close();
		    socket = null;

		    if (/*isInitiator &&*/ (node.state!=Node.DORMANT) &&
			(node.state!=Node.INACTIVE))   
		    
		    {	// then re-connect			
			overlayMn.removeNeighbor(node);
			isReceiving=false;
			break;

/*			if (retries++ > 1) {
			    printStatus("Giving up on a node... ");
			    overlayMn.removeNeighbor(node);
			    isReceiving=false;
			    break;
			}

			printStatus("Re-establishing TCP connection to node "+
				node.toString());

			socket = new Socket(node.ia, node.TCPport);
			in = new DataInputStream(socket.getInputStream());
			DataOutputStream out = new DataOutputStream(
				socket.getOutputStream());

			printStatus("... connected (local port = " + 
				socket.getLocalPort());

			// Send out the TCP port I listen to so remote 
			// node can check that I am a permitted neighbor 
			// to connect
			out.writeInt(comm.TCPport);

			// Update data in Node
			node.in = in;
			node.out = out;

			retries = 0;
*/		    }
		    else 
		    { 
			node.in=null;
			if (node.out != null) node.out.close();
			node.out=null;
			node.thread=null; 
			node.state = Node.INACTIVE;
			break;
		    }
		}

		// printStatus("... about to call in.readInt()");
		packetLen = in.readInt();
		// printStatus("... about to call in.readFully()");
		in.readFully(receiveBuffer, 0, packetLen);

		p = new Packet(receiveBuffer, packetLen);

		// printStatus("... about to call forwarder.forwardByTCP()");
		if (p==null)
		    printStatus("Cannot create Packet");
		else
		    forwarder.forwardByTCP(p, node);

	    } catch (IOException e) {
		if (!isReceiving || (node.state==Node.DORMANT) || 
			(node.state==Node.INACTIVE))
		{
		    printStatus("Request to terminate TCP connection to " +
			node.toString() + " is confirmed.");
		    isReceiving = false;
		}
		else
		{
		    printStatus(e.getMessage());
		    e.printStackTrace();
		    in = null;
		}
	    } catch (Exception e) {
		if (!isReceiving || (node.state==Node.DORMANT) || 
			(node.state==Node.INACTIVE))
		{
		    printStatus("Request to terminate TCP connection to " +
			node.toString() + " is confirmed.");
		    isReceiving = false;
		}
		else
		{
		    printStatus(e.getMessage());
		    e.printStackTrace();
		}
		// printStatus("Received bad packet from " + node.toString());
	    }
	}


	try {
	if (socket != null) 
	{
	    socket.close();
	    printStatus("TCP socket was closed.");
	    socket = null;
	}
	
	if (node.in != null) node.in.close();
	if (node.out != null) node.out.close();
	} catch (IOException e) {
	    printStatus(e.getMessage());
	    e.printStackTrace();
	}
	
	node.in=null;
	node.out=null;
	node.thread=null; 
	node.state = Node.INACTIVE;
	
	printStatus("TCP thread exits.");

    }

    void printStatus(String s)
    {
	System.out.println("TCPForwardThread:" + s);
    }
}
