package ins.inr;

import ins.namespace.*;
import java.util.*;
import java.net.*;

/**
 * TwineAdvManager.java 
 * <br>
 * This class holds the set of latest advertisements
 * corresponding to all directly connected resources
 * <br>
 * All advertisements are periodically marked. When
 * an advertisement is marked, it is refreshed within 
 * the core of resolvers on the next advertisement 
 * received at the edge (from the directly connected resource).
 * <br><br>
 * Created: Mon Oct 15 2001 <br>
 * Modified: $Id: TwineAdvManager.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 *
 */
public class TwineAdvManager  extends TimerTask {

    // Advertisements are indexed by name-records
    // of corresponding resources
    Hashtable indexByNameRec;
    Timer timer;
    
    public TwineAdvManager() {
	indexByNameRec = new Hashtable();
    }

    public void init(Resolver r) {

	timer = ((TwineResolver)r).timer;
	timer.scheduleAtFixedRate(this,RouteManager.MAX_NAME_CORE_TTL/2,
				  RouteManager.MAX_NAME_CORE_TTL/2);
	
    }

    /**
     * Periodically reset all advertisements so they will get
     * refreshed within the network of resolvers.
     */
    public void run() {

	for (Enumeration enum = indexByNameRec.elements(); enum.hasMoreElements();) {

	    System.out.println("REFRESHING ADVERTISEMENTS");
	    TwineAdvertisement ta = (TwineAdvertisement)enum.nextElement();
	    ta.setShouldBeRefreshed();

	}

    }

    /**
     * If we already had an advertisement for this name-record,
     * we update the sequence number and packet
     * Otherwise, if we already had an advertisement for this
     * sequence number, we update the packet
     * Otherwise, we create a new advertisement
     */
    public synchronized TwineAdvertisement newAdvertisement(int seqNum, 
							    int nameRecID,
							    Packet p,
							    int nbKeys) {
	
	Integer nrID = new Integer(nameRecID);
	TwineAdvertisement ad = (TwineAdvertisement)indexByNameRec.get(nrID);
	if ( ad != null)
	    ad.reset(seqNum,p,nbKeys);
	else {
	    ad = new TwineAdvertisement(seqNum,p,nbKeys);
	    indexByNameRec.put(new Integer(nameRecID),ad);
	}
	return ad;
    }

    public synchronized TwineAdvertisement getAdByNameRec(int nameRecID) {
	return (TwineAdvertisement)indexByNameRec.get(new Integer(nameRecID));
    }

    public synchronized void removeAdForNameRec(int nameRecID) {
	Integer nrID = new Integer(nameRecID);
	indexByNameRec.remove(nrID);
    }
    
}
    
