package ins.inr;

import ins.dsr.*;
import java.util.*;
import java.net.*;


/**
 * TwineDSRManager.java
 * <br>
 * The TwineDSRManager asks the DSR about
 * all available resolvers
 * <br>
 * Created: Tue Jun 19 12:56:34 2001 <br>
 * $Id: TwineDSRManager.java,v 1.3 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 * @version 1.0
 */

public class TwineDSRManager extends DSRManager {

    boolean connected = false;

    public TwineDSRManager(String[] dsrs) throws Exception {
	
	super(dsrs);

    }


    /** 
     * Overriding the init method to get rid of
     * unwanted resources;
     */

    public void init(Resolver r) 
    {
	resolvers = null;
	neighbors = null;
	comm = r.comm;
	nameTrees = r.nameTrees;

	(new Thread(this)).start();
	vannouncer = new VspaceAnnouncer(this, 1200000); //say every 20 minutes
    }


    /**
     * Processes a DSRResponse of type VspacesResolvers,
     * A TwineDSRManager behaves differently than a
     * DSRManager as all Twine resolvers run in the 
     * same vspace.
     * We don't need this method, because we're connecting
     * at the key router level
     */
    protected void processVspacesResolvers
	(DSRResponse response)
    {

	long currentTime = System.currentTimeMillis();
	lastVspacesResolvers = currentTime;
	

	// If we're joining the network, we have to connect
	// to appropriate resolvers.
	if ( !connected ) {

	    // for each advertised vspace
	    for (Enumeration vsnodes = response.getElements();
		 vsnodes.hasMoreElements(); ) {

		ins.dsr.VSNodes vsn = (ins.dsr.VSNodes)vsnodes.nextElement();
		String vspace = vsn.getVspace();
	    
		// add advertised resolvers that we may not have
		for (Enumeration nodes = vsn.getNodes();
		     nodes.hasMoreElements(); ) {

		    ins.dsr.Node node = (ins.dsr.Node)nodes.nextElement();

		    InetAddress ia = node.getInetAddress();
		    int UDPport = node.getUDPport();
		    int TCPport = node.getTCPport();

		    // don't add yourself :)
		    if ((UDPport == comm.UDPport) && 
			(TCPport == comm.TCPport) &&
			(comm.localhost.equals(ia)))
			continue;

		    System.out.println(":: Should be connecting to: "
				       +vspace+":"+ia+":"+ UDPport+":"+TCPport);
		    connected = true;
		    
		}
	    }
	}
	
    } 

  
    /** 
     * We don't use method getNodeInVspace from ancestor.
     * We hide it to avoid any bogus usage.
     */
    public Node getNodeInVspace(String vspace)
    {
	return null;
    }

}
