package ins.inr;

import ins.namespace.*;

/**
 * TwineForwader.java
 * <br>
 * 
 * Dispatches incoming messages to appropriate
 * handlers.
 * <p>
 * Created: Tue Jun 19 10:48:35 2001<br>
 * Modified: $Id: TwineForwarder.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 *
 * @author Magdalena Balazinska
 * @author Kalpak Kothari
 * @version 1.0
 */ 

public class TwineForwarder extends Forwarder {

    protected NameStoreInterface nameTree;
    public static String controlmsg = "control-msg";
    protected TwineLogger log;
    protected TwineMetricEstimator tme;

    public TwineForwarder() {
	log = new TwineLogger("FWD");
    }
    

    void init(Resolver r)
    {

	// Initializing some resources
	resolver = r;
	comm = r.comm;
	dsrMn = r.dsrMn;
	tme = ((TwineResolver)r).tme;	// added by kalpak
	
	// Twine resolver specific
	nameTree = ((TwineResolver)r).nameTree;

	// Explicitely not initializing some 
	// resources used by ancestor.
	nameTrees = null;
	routeTables = null;
	resolvers = null;
	routeMn = r.routeMn;
	appMn = r.appMn;	// changed by kalpak (was null)
	myuidRE = null;
	nextHopList = null;

    }


    /**
     * Forwards incoming message to appropriate handler.
     * <ul><li>Messages from applications are handled by TwineAppManager
     * <li>Messages from other resolvers are handled by TwineInterResolver
     * </ul>
     * Added support for handling late-binding messages (kalpak).
     * @param msg incoming message
     */

    synchronized void forward(Message msg)
    {
	// Infer source name and disseminate it if necessary
	Packet packet = msg.getPacket();
	log.printStatus("UDP receives a packet...\n", TwineLogger.TRACE_MSG);
	log.printStatus(packet.toString(),TwineLogger.TRACE_MSG);

	// If packet is a control message then use appropriate handler
	if ( isControlMessage(packet.dNS) ) {

	    NameRecord [] result = nameTree.lookup(packet.dNS);	    
	    if ( (result != null) && (result.length > 0) && (result[0] != null)) {
		IHandler h = result[0].getHandler();
		h.INSreceive(new Message(packet, msg.ia, msg.port));
	    }
	    else {
		log.printStatus("\nNo handler for this control message: dropping",
				TwineLogger.IMPORTANT_MSG);
	    }
	    
	}
	else {
	    // this is a late-binding message

	    if (packet.decrementTTL() == 0) {
		log.printStatus("\nPacket TTL reaches zero: dropping",
				TwineLogger.IMPORTANT_MSG);
		return;
	    }

	    // update multicast source number in TwineMetricEstimator
	    if(msg.packet.all) {
		long inruid = -1;
		byte[] addr = msg.ia.getAddress();
		inruid = (long)(Conversion.extract32toInt(addr, 0));
		inruid = (inruid << 16) | ((long)msg.port & 0xFFFFl);
		tme.updateMulticastSources(inruid);
	    }

	    if(packet.fromApp) {
		// incoming late-binding message from application, appMn can handle it
		appMn.INSreceive(msg);
		// i wonder why in the previous section, INSreceive is
		// given a new Message().
	    }
	    else {
		// incoming late-binding message from another resolver.
		// this means we have to forward this packet to local
		// destinations matching the destination NS in this messagee.
		
		// TwineInterResolver should handle this
		((TwineInterResolver)routeMn).INSreceive(msg);
		
	    }
	    
	    //	    log.printStatus("\nLate binding messages are mostly supported:"+
	    //			    "start flipping a coin to see if this worked.",
	    //			    TwineLogger.INFO_MSG);
	}
    }

    /**
     * 
     */
    public boolean isControlMessage(NameSpecifier ns) {

	if (ns.toString().indexOf(controlmsg) != -1)
	    return true;
	else 
	    return false;
	
    }

}
