package ins.inr;

import ins.namespace.*;
import java.util.*;
import java.net.*;

// To display resources graphically
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * TwineGUI.java
 * <br>
 * Displays the content of the name tree graphically.
 * Useful for debugging. <br>
 * Created: Thu Aug 9 11:36:50 2001 <br>
 * Modified: $Id: TwineGUI.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 * @version 1.0
 */

public class TwineGUI extends TimerTask {

    protected NameStoreInterface nameTree;
    protected long INRuid;
    protected String title;
    JTextArea text;
    protected String prefix = "*** Name Tree *** \n" ;
    java.util.Timer timer;
    public static int REFRESH_INTERVAL = 1000; // Refresh display every 1s

    //-----------------------------------------------------
    /**
     *
     */
    public TwineGUI() {
    }

    //-----------------------------------------------------
    /**
     *
     */
    public void init(Resolver r) {

	nameTree = ((TwineResolver)r).nameTree;
	INRuid = r.INRuid;
	title = r.comm.localhost.toString();
	if ( TwineResolver.DISPLAY ) {
	    displayWindow();
	}

	// Refresh display periodically
	timer = ((TwineResolver)r).timer;
	timer.scheduleAtFixedRate(this,REFRESH_INTERVAL,REFRESH_INTERVAL);

    }


    //-----------------------------------------------------
    /**
     *
     */
    protected void displayWindow() {

	JFrame frame = new JFrame(title);

	frame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {System.exit(0);}
	    });
	

	text = new JTextArea(prefix + nameTree.toPrettyString());
        text.setPreferredSize(new Dimension(500, 500));

	frame.getContentPane().add(text, BorderLayout.CENTER);

	frame.pack();
	frame.setVisible(true);
    }
    

    //-----------------------------------------------------
    /**
     *
     */
    public synchronized void updateColorDisplay() {

	
	if ( !TwineResolver.DISPLAY )
	    return;

	if ( text == null )
	    displayWindow();

	Enumeration elements;
	
	text.replaceRange(prefix + nameTree.toPrettyString(),0,text.getText().length());
	text.append("\n\n ----> Directly connected: \n");

	for ( elements = nameTree.getNameRecords(); elements.hasMoreElements();) {
	    
	    NameRecord nr = (NameRecord)elements.nextElement();
	    boolean mine = (nr.getINRuid() == INRuid);
	    
	    if ( mine )
		text.append(" - " + nr.getID());
	}

    }

    //-----------------------------------------------------
    /**
     *
     */
    public void run() {
	updateColorDisplay();
    }

}
