package ins.inr;

import java.io.*;

/**
 * TwineLogger.java <br>
 * Helper class for log files and
 * log messages. <br>
 * Created: Tue Jun 26 10:39:02 2001 <br>
 * Modified: $Id: TwineLogger.java,v 1.4 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 */

public class TwineLogger  {

    public static int TRACE_MSG = 4;
    public static int INFO_MSG = 3;
    public static int IMPORTANT_MSG = 2;
    public static int KEY_MSG = 1;

    protected String prefix;
    PrintWriter pw;
    boolean isLog;

    //-----------------------------------------------------
    /** 
     *
     */
    public TwineLogger (String p, String logfile) {

	prefix = p;

	isLog = true;
	try{
	    pw = new PrintWriter(new FileWriter(logfile), true);
	} catch (IOException e) {
	    isLog = false;
	}
	
    }

   //-----------------------------------------------------
    /** 
     *
     */
    public TwineLogger (String p, PrintWriter thePw) {

	prefix = p;
	pw = thePw;
	if ( thePw != null )
	    isLog = true;
	else isLog = false;

    }


    //-----------------------------------------------------
    /** 
     *
     */
    public TwineLogger (String p) {
	
	prefix = p;
	isLog = false;

    }


    //-----------------------------------------------------
    /** 
     * Printed/logged messages are assigned an importance
     * level and are printed or not depending on the debugging
     * level
     */
    public void printStatus(String message, int level) {

	if ( level <= Resolver.DEBUG) {

	    String text = prefix + ": " +message;
	    System.out.println(text);
	    if (isLog) 
		pw.println(text);

	}
    }

    
} // TwineLogger
