package ins.inr;

import ins.namespace.*;

/**
 * TwineNetProber.java
 *
 * Used for calculating ping times between resolvers.
 *
 * Created: Thu Jun 21 11:07:44 2001
 *
 * @author Magdalena Balazinska
 * @author Kalpak Kothari
 * @version 1.0
 */

public class TwineNetProber extends NetProber {

    protected NameStoreInterface nameTree;
    protected TwineLogger log;

    public void init(Resolver r)
    {
	log = new TwineLogger("TNP","TwineNetProber.log");
	nameTree = ((TwineResolver)r).nameTree;
	super.init(r);

    }


    void produceVspace(String vspace)
    {
	NameRecord nr;
	nr = new NameRecord((IHandler)this, 0, -1, 0, false, resolver.INRuid);
	nameTree.addNameRecord(pingNS, nr);
	
	nr = new NameRecord((IHandler)this, 0, -1, 0, false, resolver.INRuid);
	nameTree.addNameRecord(pingackNS, nr);
	
	nr = new NameRecord((IHandler)this, 0, -1, 0, false, resolver.INRuid);
	nameTree.addNameRecord(setNS, nr);
	
	nr = new NameRecord((IHandler)this, 0, -1, 0, false, resolver.INRuid);
	nameTree.addNameRecord(setackNS, nr);
    }

    /** 
     * No periodic pinging with Twine resolvers
     */
    void startPeriodicPing()
    {
    }

    /** 
     *  A callback function: will be called every time a new
     *  INS packet for this handler arrives by UDP.
     *  (Interface implementation of IHandler)
     *  @param msg a ping/ack control message
     */
    public void INSreceive(Message msg)
    {
	//	log.printStatus("receiving a message by UDP...", TwineLogger.TRACE_MSG);

	Packet packet = msg.packet;
	Packet p;
	String vspace = packet.dNS.getVspace();

	//	log.printStatus(packet.toString(), TwineLogger.TRACE_MSG);
	
	AVelement av = packet.dNS.getAVelement(controlmsgAttr);
	if (av.getValue().equals(pingVal)) 
	{
	    pingackNS.setVspace(vspace);
	    p = new Packet(sourceNS, pingackNS, 2, 
		Packet.toAny, false, zerobyte, zerobyte);
	    comm.sendMessage(new Message(p, msg.ia, msg.port));
	}
	else if (av.getValue().equals(pingackVal)) 
	{
	    if (!isWaitForPingAck) return;
	    if (!msg.ia.equals(pingNode.ia) || 
		(msg.port != pingNode.UDPport))
	    	return;	 // invalid or duplicate due to retransmit

	    long curTime = System.currentTimeMillis();
	    rtt = (int)(curTime - pingTime);
	    
	    isWaitForPingAck = false;
	    synchronized (waitForPingAck) {
		waitForPingAck.notifyAll();
	    }
	}
	else if (av.getValue().equals(setVal)) 
	{
	    // useless FIX THIS! stop sending setacks perhaps.
	}
	else if (av.getValue().equals(setackVal)) 
	{
	    isWaitForSetAck = false;
	    // useless
	}
    }

    protected void determineRTT(Node n, String vspace)
    {
	pingNS.setVspace(vspace);
	Packet p = new Packet(sourceNS, pingNS, 2, 
		Packet.toAny, false, zerobyte, zerobyte);
	Message msg = new Message(p, n.ia, n.UDPport);

	pingNode = n;
	isWaitForPingAck = true;
	pingTime = System.currentTimeMillis();
	comm.sendMessage(msg);

	try {
	synchronized(waitForPingAck) {
	    waitForPingAck.wait();
	}
	} catch (InterruptedException e) {
	    e.printStackTrace();
	}

	n.rtt = rtt;

	log.printStatus(n.toString(), TwineLogger.TRACE_MSG);
    }


}
