package ins.inr;

import ins.namespace.*;
import java.util.*;

/**
 * TwineStrandSplitter.java <br>
 *
 * This class takes name-specifiers and
 * extracs all prefixes from them.
 * Currently both attribs and values
 * are always used. The attrib only
 * option is not implemented
 * <br>
 * Created: Thu Jun 21 13:43:37 2001 <br>
 * Modified: $Id: TwinePrefixes.java,v 1.3 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 */

public class TwinePrefixes extends TwineStrandSplitter  {

    //-----------------------------------------------------
    /**
     */
    public TwinePrefixes() {
	
    }
    
    
    //-----------------------------------------------------
    /**
     * This method splits a name-specifier into a vector of String[] 
     * corresponding to sequences of elements in its strands.
     * Strands containing a single top level attribute are ignored
     * If there are no strands of at least one attrib and one value,
     * then this method returns an empty vector
     * @param ns The name specifier that should be split
     * @return This method returns a Vector of Strands[]
     * corresponding to sequences of attributes.
     */
    public Vector splitToStrands(NameSpecifier ns) { 

	int index = 0;	
	Vector allStrands = new Vector();

	// Recursively split all root attribs into strands.
	for (Enumeration e = ns.getAVelements(); e.hasMoreElements(); ) {
	    AVelement av = (AVelement)e.nextElement();
	    if ( checkValue(av) || av.getAVelements().hasMoreElements()) {
		String[] strand = new String[2];
		addAttrib(av,strand,0);
		addValue(av,strand,1);
		allStrands.addElement(strand);
		extractPrefixes(av,allStrands,strand);
	    }
	}
	log.printStatus(printStrandSet(allStrands),TwineLogger.TRACE_MSG);
	return allStrands;
    }


    //-----------------------------------------------------
    /**
     *  This method performs the actual prefix extraction. 
     */
    protected void extractPrefixes(AVelement av, Vector allStrands, String[] myStrand) {
	
	if ( av != null ) {

	    if ( av.isLeaf() || (myStrand.length >= MAX_DEPTH - 1) ) {
		return;
	    }

	    else {

		// For all children attributes
		for (Enumeration e = av.getAVelements(); e.hasMoreElements(); ) {     

		    AVelement childAV = (AVelement)e.nextElement();

		    String[] childAttribStrand = new String[myStrand.length+1];
		    System.arraycopy(myStrand,0,childAttribStrand,0,myStrand.length);
		    addAttrib(childAV,childAttribStrand,myStrand.length);
		    allStrands.addElement(childAttribStrand);

		    if ( checkValue(childAV)) {
			String[] childValueStrand = new String[childAttribStrand.length+1];
			System.arraycopy(childAttribStrand,0,childValueStrand,0,
					 childAttribStrand.length);
			addValue(childAV,childValueStrand,childAttribStrand.length);
			allStrands.addElement(childValueStrand);
			extractPrefixes(childAV,allStrands,childValueStrand);
		    }
		}
		
	    }
	}
	    
    }


    //-----------------------------------------------------
    /**
     * 
     */
    public void addAttrib(AVelement av, String[] strand, int index) {

	//String thisAttrib = "empty";
	//if ( av.getAttribute() != null )
	String  thisAttrib = av.getAttribute().toString();
	strand[index] = thisAttrib; 
	
    }  

    //-----------------------------------------------------
    /**
     * We allow empty values only at the leaf, never in the middle
     */
    public void addValue(AVelement av, String[] strand, int index) {

	//String thisValue = null;

	//if ( av.getValue != null )
	String thisValue = av.getValue().toString();
	//else if ( !av.isLeaf()) 
	//  thisValue = "empty";

	strand[index] = thisValue; 
	
    }  

    //-----------------------------------------------------
    /**
     * Check if the value is missing or is a wildcard
     */
    public boolean checkValue(AVelement av) {

	boolean isFine = true;
	Value value = av.getValue();
	if ( (value == null) || (value.isWildcard()))
	    isFine = false;
	return isFine;

    }


}
