package ins.inr;

import ins.namespace.*;
import java.util.*;
import java.net.*;

/**
 * TwineQuery.java <br>
 * 
 * Represents a pending query <br>
 * 
 * Created: Tue Aug 14 11:15 2001 <br>
 * Modified: $Id: TwineQuery.java,v 1.5 2002/03/21 00:01:55 mbalazin Exp $
 * @author Magdalena Balazinska
 */
public class TwineQuery implements TwineMessage {

    NameSpecifier ns;
    int clientSeqNum; // This is the sequence number used by OUR client!
    InetAddress addr;
    int port;
    int queryType;
    long timeOut;
    int pendingAnswers;
    boolean all; // All results shall be returned.

    Integer mySeqNum;
    Vector results;
    Vector strands;
    Packet packet;
  
    //-----------------------------------------------------
    /**
     * Class constructor
     */
    public TwineQuery(NameSpecifier nameSpec, int sequence, InetAddress address, 
		      int p, int querytype, boolean returnAllResults) {

	ns = nameSpec;
	mySeqNum = null;
	results = null;
	clientSeqNum = sequence;
	addr = address;
	port = p;
	queryType = querytype;
	timeOut = System.currentTimeMillis() + TwineResolver.QUERY_TO;
	pendingAnswers = 0;
	all = returnAllResults;
	strands = null;
	packet = null;

	// To remember to whom we send the query for each key
	keys = new Hashtable();
    }

    //-----------------------------------------------------
    /**
     * When a new query is stored in the query manager,
     * its unique ID is set and the list of results that
     * have already been obtained is stored as well.
     * @param mySeqNb unique ID for this query
     * @param partialRes list of resources matching the query
     */
    public void prepareToStore(int mySeqNb,Vector partialRes) {
	
	mySeqNum = new Integer(mySeqNb);
	results = partialRes;

    }
    
    //-----------------------------------------------------
    /**
     *
     */
    public NameSpecifier getNameSpec() { return ns; }
    public void addPendingAnswers(int number) { pendingAnswers += number; }
    public void decPending() { pendingAnswers--; }
    public Vector getResults() { return results; }
    public InetAddress getAddr () { return addr;}
    public int getPort () { return port;}
    public int getType () { return queryType;}
    public boolean expired (long time) { return time >= timeOut;}
    public int getPending () { return pendingAnswers;}
    public Integer getID () { return mySeqNum;}
    public int getClientSeqNum () { return clientSeqNum;}
    public boolean allResults() { return all;}
    public void setStrands(Vector theStrands) { strands = theStrands; }
    public Vector getStrands() { return strands; }
    public void setPacket(Packet p) { packet = p; }

    //-----------------------------------------------------
    // Methods from interface TwineMessage
    //-----------------------------------------------------

    public Packet getPacket() { return packet; }
    public int getSeqNo() { return mySeqNum.intValue(); }

    protected Hashtable keys;

    /**
     * We should send a query if we didn't send the query using
     * the specific key!
     */
    public boolean shouldSend(byte[] byteKey, InetAddress addr, int port) {

	String temp = addr.toString() + port;
	int id = Conversion.extract32toInt(byteKey,byteKey.length-OFFSET);
	Integer integerID = new Integer(id);
	Hashtable hosts = (Hashtable)keys.get(integerID);
	if ( hosts == null) {
	    hosts = new Hashtable();
	    keys.put(integerID,hosts);
	    hosts.put(temp,temp);
	    return true;
	}
	else if ( hosts.get(temp) == null ) {
	    hosts.put(temp,temp);
	    return true;
	}
	else { 
	    return false;
	}
    }


    //-----------------------------------------------------
    /**
     */
    public String toString() {
	TwineQuery q = this;
	String output = "";
	output = output +  " addr " + q.getAddr().toString() + " " 
	    + "\n seqNum " + q.getClientSeqNum() + " "
	    + "\n port " + q.getPort() + " "
	    + "\n queryType " + q.getType() + " "
	    + "\n expired " + q.expired(System.currentTimeMillis()) + " "
	    + "\n waiting on " + q.getPending() + " "
	    + "\n key " + q.getID() + " "
	    + "\n accumulated results "; 
	if ( q != null && q.getResults() != null) {
	    for ( Enumeration eNR = q.getResults().elements(); eNR.hasMoreElements();) {
		Object o = eNR.nextElement();
		output = output + o.toString() + " -  ";
		
	    }
	}
	return output;
    }
}
