package ins.inr;

import ins.namespace.*;
import java.util.*;
import java.net.*;

/**
 * TwineStats.java <br>
 * Wakes-up periodically and gather statistics
 * about the resolver. <br>
 * @author Magdalena Balazinska
 * @version 1.0
 */

public class TwineStats extends TimerTask {

    public static int DUMP_INTERVAL = 20000;

    protected NameStoreInterface nameTree;
    protected long INRuid;
    protected java.util.Timer timer;  
    protected TwineLogger log;
    protected int offset;
    protected int nbRejectedKeys;

    //-----------------------------------------------------
    /**
     *
     */
    public TwineStats() {	
	log = new TwineLogger("TwineStats","TwineStats.log");
	nbRejectedKeys = 0;
    }

    //-----------------------------------------------------
    /**
     *
     */
    public void init(Resolver r) {

	nameTree = ((TwineResolver)r).nameTree;
	INRuid = r.INRuid;

	timer = ((TwineResolver)r).timer;
	timer.scheduleAtFixedRate(this,DUMP_INTERVAL,DUMP_INTERVAL);
	offset = countResources();
 
   }

    
    //-----------------------------------------------------
    /**
     * Called whenever the number of resources for any
     * given key exceeds a threshold. In that case, no
     * new resource will be stored under the key.
     * See <code>TwineKeyManager</code>
     */
    public void stopStoringOneKey() { nbRejectedKeys++;}
   
    //-----------------------------------------------------
    /**
     * Counts the number of resources known to this resolver
     * at one particular moment in time.
     */
    public int countResources() {

	int counter = 0;
	for ( Enumeration  elements = nameTree.getNameRecords(); elements.hasMoreElements();) {
	    elements.nextElement();
	    counter++;
	}
	return counter;

    }

    //-----------------------------------------------------
    /**
     *
     */
    public void run() {

	log.printStatus("NbRejectedKeys: " + nbRejectedKeys + " NbResources: "+ (countResources()-offset),
			TwineLogger.KEY_MSG);

    }

}
