package ins.inr;

import ins.namespace.*;
import java.util.*;

/**
 * TwineStrandSplitter.java <br>
 *
 * This class defines the basic
 * methods for splitting AVTrees
 * into strands using attributes 
 * and optionnaly values
 * <br>
 * Created: Sun Sep 30 2001 <br>
 * Modified: $Id: TwineStrandSplitter.java,v 1.3 2002/03/21 00:01:55 mbalazin Exp $
 *
 * @author Magdalena Balazinska 
 *
 */

public abstract class TwineStrandSplitter {

    public static int MAX_DEPTH = 5;

    // The following determine how to split into strands
    public static final int ATTRIB_STRANDS = 0;
    public static final int ATTRIB_VALUE_STRANDS = 1;
    public static int TYPE_STRANDS = ATTRIB_VALUE_STRANDS;
    protected TwineLogger log;

    public TwineStrandSplitter() {
	log = new TwineLogger("StrandSplitter");
    }

    public Vector splitToStrands(NameSpecifier ns) {
	return null;
    }


    //-----------------------------------------------------
    /**
     *  Prints a set of strands.
     *  @param allStrands Vector of String[] where each element
     *  of the vector represents one strand, and each element of
     *  a string array is one element of a strand.
     */
    public static String printStrandSet(Vector allStrands) {

	StringBuffer result = new StringBuffer();
	result.append("\nPrinting set of strands: ");
	for (Enumeration enum = allStrands.elements(); enum.hasMoreElements(); ) {
	    result.append(printOneStrand((String[])enum.nextElement()));
	}
	return result.toString();
    }


    //-----------------------------------------------------
    /**
     *  Prints one strand
     *  @param s String[] where each string in the array
     *  is an element of the strand.
     */
    public static String printOneStrand(String[] s) {

	StringBuffer result = new StringBuffer();
	result.append("Strand: ");
	for ( int i = 0; i < s.length; i++ ) {
	    result.append(" - " + s[i] );		
	}
	result.append("\n");
	return result.toString();
    }



}
